/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.query;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.query.sql.SqlExecutor;
import com.jpattern.orm.query.sql.SqlFindQuery;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.ResultSetRowReader;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.transaction.Transaction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class PlainSqlExecutorsRowReaderTest
extends BaseTestShared {
    private Employee employee1;
    private Employee employee2;
    private Employee employee3;
    private Session session;

    @Override
    protected void setUp() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(Employee.class);
        this.session = jpOrm.session();
        Transaction tx = this.session.transaction();
        this.session.deleteQuery(Employee.class).perform();
        Random random = new Random();
        this.employee1 = new Employee();
        this.employee1.setId(random.nextInt());
        this.employee1.setAge(44);
        this.session.save((Object)this.employee1);
        this.employee2 = new Employee();
        this.employee2.setId(random.nextInt());
        this.employee2.setAge(44);
        this.session.save((Object)this.employee2);
        this.employee3 = new Employee();
        this.employee3.setId(random.nextInt());
        this.employee3.setAge(45);
        this.session.save((Object)this.employee3);
        tx.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        Transaction tx = this.session.transaction();
        this.session.delete((Object)this.employee1);
        this.session.delete((Object)this.employee2);
        this.session.delete((Object)this.employee3);
        tx.commit();
    }

    @Test
    public void testResultSetReaderWithTwoResults() {
        SqlExecutor sqlExecutor = this.session.sqlExecutor();
        SqlFindQuery findQuery = sqlExecutor.findQuery("select * from Employee where age = ?", new Object[]{44});
        List results = (List)findQuery.find((ResultSetReader)new ResultSetReader<List<Integer>>(){

            public List<Integer> read(ResultSet resultSet) throws SQLException {
                ArrayList<Integer> results = new ArrayList<Integer>();
                while (resultSet.next()) {
                    results.add(resultSet.getInt("id"));
                }
                return results;
            }
        });
        System.out.println("Result is " + results);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(this.employee1.getId()));
        Assert.assertTrue((boolean)results.contains(this.employee2.getId()));
    }

    @Test
    public void testResultSetRowReaderWithTwoResults() {
        final AtomicInteger atomicRownNum = new AtomicInteger(-1);
        SqlExecutor sqlExecutor = this.session.sqlExecutor();
        SqlFindQuery findQuery = sqlExecutor.findQuery("select * from Employee where age = ?", new Object[]{44});
        List results = findQuery.find((ResultSetRowReader)new ResultSetRowReader<Integer>(){

            public Integer readRow(ResultSet rs, int rowNum) throws SQLException {
                atomicRownNum.set(rowNum);
                return rs.getInt("id");
            }
        });
        System.out.println("Result is " + results);
        System.out.println("atomicRownNum is " + atomicRownNum);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)1L, (long)atomicRownNum.get());
        Assert.assertTrue((boolean)results.contains(this.employee1.getId()));
        Assert.assertTrue((boolean)results.contains(this.employee2.getId()));
    }

    @Test
    public void testResultSetRowReaderWithOneResult() {
        final AtomicInteger atomicRownNum = new AtomicInteger(-1);
        SqlExecutor sqlExecutor = this.session.sqlExecutor();
        SqlFindQuery findQuery = sqlExecutor.findQuery("select * from Employee where age = ?", new Object[]{45});
        List results = findQuery.find((ResultSetRowReader)new ResultSetRowReader<Integer>(){

            public Integer readRow(ResultSet rs, int rowNum) throws SQLException {
                atomicRownNum.set(rowNum);
                return rs.getInt("id");
            }
        });
        System.out.println("Result is " + results);
        System.out.println("atomicRownNum is " + atomicRownNum);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)0L, (long)atomicRownNum.get());
        Assert.assertTrue((boolean)results.contains(this.employee3.getId()));
    }

    @Test
    public void testResultSetRowReaderWithNoResult() {
        final AtomicInteger atomicRownNum = new AtomicInteger(-1);
        SqlExecutor sqlExecutor = this.session.sqlExecutor();
        SqlFindQuery findQuery = sqlExecutor.findQuery("select * from Employee where age = ?", new Object[]{46});
        List results = findQuery.find((ResultSetRowReader)new ResultSetRowReader<Integer>(){

            public Integer readRow(ResultSet rs, int rowNum) throws SQLException {
                atomicRownNum.set(rowNum);
                return rs.getInt("id");
            }
        });
        System.out.println("Result is " + results);
        System.out.println("atomicRownNum is " + atomicRownNum);
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertEquals((long)-1L, (long)atomicRownNum.get());
    }

    @Test
    public void testResultSetRowReaderUniqueWithTwoResults() {
        final AtomicInteger atomicRownNum = new AtomicInteger(-1);
        SqlExecutor sqlExecutor = this.session.sqlExecutor();
        SqlFindQuery findQuery = sqlExecutor.findQuery("select * from Employee where age = ?", new Object[]{44});
        try {
            findQuery.findUnique((ResultSetRowReader)new ResultSetRowReader<Integer>(){

                public Integer readRow(ResultSet rs, int rowNum) throws SQLException {
                    atomicRownNum.set(rowNum);
                    return rs.getInt("id");
                }
            });
            Assert.fail((String)"an exception should be thrown before");
        }
        catch (OrmNotUniqueResultException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("higher"));
        }
    }

    @Test
    public void testResultSetRowReaderUniqueWithNoResults() {
        final AtomicInteger atomicRownNum = new AtomicInteger(-1);
        SqlExecutor sqlExecutor = this.session.sqlExecutor();
        SqlFindQuery findQuery = sqlExecutor.findQuery("select * from Employee where age = ?", new Object[]{46});
        try {
            findQuery.findUnique((ResultSetRowReader)new ResultSetRowReader<Integer>(){

                public Integer readRow(ResultSet rs, int rowNum) throws SQLException {
                    atomicRownNum.set(rowNum);
                    return rs.getInt("id");
                }
            });
            Assert.fail((String)"an exception should be thrown before");
        }
        catch (OrmNotUniqueResultException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("zero"));
        }
    }

    @Test
    public void testResultSetRowReaderUniqueWithOneResult() {
        final AtomicInteger atomicRownNum = new AtomicInteger(-1);
        SqlExecutor sqlExecutor = this.session.sqlExecutor();
        SqlFindQuery findQuery = sqlExecutor.findQuery("select * from Employee where age = ?", new Object[]{45});
        Integer result = (Integer)findQuery.findUnique((ResultSetRowReader)new ResultSetRowReader<Integer>(){

            public Integer readRow(ResultSet rs, int rowNum) throws SQLException {
                atomicRownNum.set(rowNum);
                return rs.getInt("id");
            }
        });
        Assert.assertEquals((Object)this.employee3.getId(), (Object)result);
        Assert.assertEquals((long)0L, (long)atomicRownNum.get());
    }
}

