/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.query;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.query.sql.SqlExecutor;
import com.jpattern.orm.session.GeneratedKeyReader;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.transaction.Transaction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PlainSqlExecutorsTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testExecuteAll() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        Session session = jpOrm.session();
        SqlExecutor sqlExecutor = session.sqlExecutor();
        Transaction tx = session.transaction();
        List<Long> ids = this.sqlExecutorInsert(sqlExecutor);
        tx.commit();
        this.checkExistAll(ids, sqlExecutor, true);
        tx = session.transaction();
        this.sqlExecutorDelete(ids, sqlExecutor);
        tx.commit();
        this.checkExistAll(ids, sqlExecutor, false);
    }

    private void sqlExecutorDelete(List<Long> ids, SqlExecutor sqlExecutor) {
        String sql = "delete from people where id = ?";
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        for (Long id : ids) {
            args.add(new Object[]{id});
        }
        sqlExecutor.batchUpdate("delete from people where id = ?", args).execute();
    }

    private List<Long> sqlExecutorInsert(SqlExecutor sqlExec) {
        final ArrayList<Long> results = new ArrayList<Long>();
        long idMain = new Date().getTime();
        long id1 = idMain++;
        results.add(id1);
        String sqlFixed = "insert into people (id, firstname, lastname) values ( " + id1 + " , 'fixed name' , 'fixed surname' )";
        Assert.assertEquals((long)1L, (long)sqlExec.updateQuery(sqlFixed, new Object[0]).update());
        String sql1 = "insert into people (id, firstname, lastname) values ( ? , ? , ? )";
        long id2 = idMain++;
        results.add(id2);
        Assert.assertEquals((long)1L, (long)sqlExec.updateQuery("insert into people (id, firstname, lastname) values ( ? , ? , ? )", new Object[]{id2, "name-" + id2, "surname-" + id2}).update());
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        long id3 = idMain++;
        long id4 = idMain++;
        long id5 = idMain++;
        results.add(id3);
        results.add(id4);
        results.add(id5);
        args.add(new Object[]{id3, "name-" + id3, "batchUpdate(sql1, args) " + id3});
        args.add(new Object[]{id4, "name-" + id4, "batchUpdate(sql1, args) " + id4});
        args.add(new Object[]{id5, "name-" + id5, "batchUpdate(sql1, args) " + id5});
        Assert.assertEquals((long)3L, (long)sqlExec.batchUpdate("insert into people (id, firstname, lastname) values ( ? , ? , ? )", args).update().length);
        ArrayList<String> sqlsFixed = new ArrayList<String>();
        long id6 = idMain++;
        long id7 = idMain++;
        results.add(id6);
        results.add(id7);
        sqlsFixed.add("insert into people (id, firstname, lastname) values ( " + id6 + " , 'batchUpdate(sqlsFixed)' , '1' )");
        sqlsFixed.add("insert into people (id, firstname, lastname) values ( " + id7 + " , 'batchUpdate(sqlsFixed)' , '2' )");
        Assert.assertEquals((long)2L, (long)sqlExec.batchUpdate(sqlsFixed).update().length);
        String sqlKeyExtractor = "insert into people (id, firstname, lastname) values ( SEQ_PEOPLE.nextval , ? , ? )";
        GeneratedKeyReader generatedKeyExtractor = new GeneratedKeyReader(){

            public void read(ResultSet generatedKeyResultSet) throws SQLException {
                generatedKeyResultSet.next();
                long gk = generatedKeyResultSet.getLong(1);
                System.out.println("Generated key: " + gk);
                results.add(gk);
            }

            public String[] generatedColumnNames() {
                return new String[]{"ID"};
            }
        };
        Assert.assertEquals((long)1L, (long)sqlExec.updateQuery("insert into people (id, firstname, lastname) values ( SEQ_PEOPLE.nextval , ? , ? )", generatedKeyExtractor, new Object[]{"sqlExec.update(sqlKeyExtractor, generatedKeyExtractor, args", "1"}).update());
        return results;
    }

    private void checkExistAll(List<Long> peopleIds, SqlExecutor sqlExecutor, boolean exist) {
        String sql = "select * from people where id in ( ";
        for (int i = 0; i < peopleIds.size() - 1; ++i) {
            sql = sql + "?, ";
        }
        sql = sql + "? ) ";
        ResultSetReader<List<Long>> rse = new ResultSetReader<List<Long>>(){

            public List<Long> read(ResultSet resultSet) throws SQLException {
                ArrayList<Long> result = new ArrayList<Long>();
                while (resultSet.next()) {
                    result.add(resultSet.getLong("ID"));
                }
                return result;
            }
        };
        List result = (List)sqlExecutor.findQuery(sql, peopleIds.toArray()).find((ResultSetReader)rse);
        for (Long id : peopleIds) {
            System.out.println("Check id: " + id + " exists? " + result.contains(id));
            Assert.assertEquals((Object)exist, (Object)result.contains(id));
        }
    }
}

