/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.query;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.query.clause.where.ExpressionElement;
import com.jpattern.orm.query.clause.where.LeExpressionElement;
import com.jpattern.orm.query.find.FindQuery;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.test.domain.Zoo_People;
import com.jpattern.orm.transaction.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class QueryExecutionTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testQuery1() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Employee.class);
        classes.add(Zoo_People.class);
        Session session = jpOrm.session();
        Employee employee = this.createEmployee((JPO)jpOrm);
        FindQuery query = session.findQuery(Employee.class);
        System.out.println(query.renderSql());
        System.out.println(query.getGeneratedRowCountSql());
        String expectedSql = "SELECT Employee.ID, Employee.NAME, Employee.AGE, Employee.SURNAME, Employee.EMPLOYEE_NUMBER FROM EMPLOYEE Employee ";
        Assert.assertEquals((Object)"SELECT Employee.ID, Employee.NAME, Employee.AGE, Employee.SURNAME, Employee.EMPLOYEE_NUMBER FROM EMPLOYEE Employee ", (Object)query.renderSql());
        List employeeList = query.findList();
        Assert.assertNotNull((Object)employeeList);
        long countRowQueryResult = query.findRowCount();
        System.out.println("found employees: " + employeeList.size());
        System.out.println("count row query result: " + countRowQueryResult);
        Assert.assertTrue((employeeList.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)employeeList.size(), (long)countRowQueryResult);
        this.deleteEmployee((JPO)jpOrm, employee);
    }

    @Test
    public void testQuery2() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(Employee.class);
        jpOrm.register(Zoo_People.class);
        Session session = jpOrm.session();
        Employee employee = this.createEmployee((JPO)jpOrm);
        int maxRows = 4;
        FindQuery query = session.findQuery(Employee.class);
        query.join(Zoo_People.class, "zp");
        query.setMaxRows(4);
        query.where().not((ExpressionElement)new LeExpressionElement("Employee.id", (Object)"0"));
        query.where().ilike("zp.firstname", "%");
        System.out.println(query.renderSql());
        String expectedSql = "SELECT Employee.ID, Employee.NAME, Employee.AGE, Employee.SURNAME, Employee.EMPLOYEE_NUMBER FROM EMPLOYEE Employee , ZOO.PEOPLE zp WHERE NOT ( Employee.ID <= ? ) AND LOWER(zp.FIRSTNAME) like LOWER(?) ";
        Assert.assertEquals((Object)"SELECT Employee.ID, Employee.NAME, Employee.AGE, Employee.SURNAME, Employee.EMPLOYEE_NUMBER FROM EMPLOYEE Employee , ZOO.PEOPLE zp WHERE NOT ( Employee.ID <= ? ) AND LOWER(zp.FIRSTNAME) like LOWER(?) ", (Object)query.renderSql());
        List employeeList = query.findList();
        Assert.assertNotNull((Object)employeeList);
        System.out.println("found employees: " + employeeList.size());
        Assert.assertTrue((employeeList.size() <= 4 ? 1 : 0) != 0);
        this.deleteEmployee((JPO)jpOrm, employee);
    }

    @Test
    public void testQuery3() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(Employee.class);
        jpOrm.register(Zoo_People.class);
        Session session = jpOrm.session();
        Employee employee = this.createEmployee((JPO)jpOrm);
        int maxRows = 4;
        FindQuery query = session.findQuery(Employee.class, "e");
        query.setMaxRows(4);
        query.where().ge("e.id", (Object)"0");
        System.out.println(query.renderSql());
        String expectedSql = "SELECT e.ID, e.NAME, e.AGE, e.SURNAME, e.EMPLOYEE_NUMBER FROM EMPLOYEE e WHERE e.ID >= ? ";
        Assert.assertEquals((Object)"SELECT e.ID, e.NAME, e.AGE, e.SURNAME, e.EMPLOYEE_NUMBER FROM EMPLOYEE e WHERE e.ID >= ? ", (Object)query.renderSql());
        List employeeList = query.findList();
        Assert.assertNotNull((Object)employeeList);
        System.out.println("found employees: " + employeeList.size());
        Assert.assertTrue((employeeList.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((employeeList.size() <= 4 ? 1 : 0) != 0);
        this.deleteEmployee((JPO)jpOrm, employee);
    }

    @Test
    public void testQuery4() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(Employee.class);
        jpOrm.register(Zoo_People.class);
        Session session = jpOrm.session();
        Employee employee = this.createEmployee((JPO)jpOrm);
        Transaction tx = session.transaction();
        FindQuery query1 = session.findQuery(Employee.class);
        query1.where().eq("Employee.id", (Object)employee.getId());
        Assert.assertEquals((long)1L, (long)query1.findList().size());
        FindQuery query2 = session.findQuery(Employee.class);
        query2.where().eq("Employee.id", (Object)(-employee.getId().intValue()));
        Assert.assertEquals((long)0L, (long)query2.findList().size());
        FindQuery query3 = session.findQuery(Employee.class);
        query3.where().eq("Employee.id", (Object)employee.getId());
        Assert.assertNotNull((Object)query3.findUnique());
        FindQuery query4 = session.findQuery(Employee.class);
        query4.where().eq("Employee.id", (Object)(-employee.getId().intValue()));
        boolean notUniqueResultException = false;
        try {
            Assert.assertNull((Object)query4.findUnique());
        }
        catch (OrmNotUniqueResultException e) {
            notUniqueResultException = true;
        }
        Assert.assertTrue((boolean)notUniqueResultException);
        Assert.assertNotNull((Object)session.findUnique(Employee.class, (Object)employee.getId()));
        notUniqueResultException = false;
        try {
            Assert.assertNull((Object)session.findUnique(Employee.class, (Object)(-employee.getId().intValue())));
        }
        catch (OrmNotUniqueResultException e) {
            notUniqueResultException = true;
        }
        Assert.assertTrue((boolean)notUniqueResultException);
        tx.commit();
        this.deleteEmployee((JPO)jpOrm, employee);
    }

    private Employee createEmployee(JPO jpOrm) {
        Session ormSession = jpOrm.session();
        Transaction tx = ormSession.transaction();
        int id = new Random().nextInt(1000000);
        Employee employee = new Employee();
        employee.setId(id);
        employee.setAge(44);
        employee.setEmployeeNumber("empNumber" + id);
        employee.setName("Wizard");
        employee.setSurname("Cina");
        ormSession.save((Object)employee);
        tx.commit();
        return employee;
    }

    private void deleteEmployee(JPO jpOrm, Employee employee) {
        Session ormSession = jpOrm.session();
        Transaction tx = ormSession.transaction();
        ormSession.delete((Object)employee);
        tx.commit();
    }
}

