/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.query.forupdate;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.query.LockMode;
import com.jpattern.orm.query.OrmRowMapper;
import com.jpattern.orm.query.find.FindQuery;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.test.domain.Zoo_People;
import com.jpattern.orm.transaction.Transaction;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class QuerySelectForUpdateExecutionTest
extends BaseTestShared {
    private final long THREAD_SLEEP = 250L;

    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testQuery1() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(Employee.class);
        jpOrm.register(Zoo_People.class);
        Session session = jpOrm.session();
        Employee employeeLocked = this.createEmployee((JPO)jpOrm);
        Employee employeeUnlocked = this.createEmployee((JPO)jpOrm);
        ActorLockForUpdate actor1 = new ActorLockForUpdate((JPO)jpOrm, employeeLocked.getId().intValue(), LockMode.FOR_UPDATE, "locked");
        Thread thread1 = new Thread(actor1);
        thread1.start();
        Thread.sleep(this.THREAD_SLEEP / 5L);
        ActorLockForUpdate actor2 = new ActorLockForUpdate((JPO)jpOrm, employeeLocked.getId().intValue(), LockMode.FOR_UPDATE, "locked2");
        Thread thread2 = new Thread(actor2);
        thread2.start();
        thread1.join();
        thread2.join();
        Assert.assertFalse((boolean)actor1.exception);
        Assert.assertFalse((boolean)actor2.exception);
        Assert.assertEquals((Object)"name_locked_locked2", (Object)((Employee)session.find(Employee.class, (Object)employeeLocked.getId())).getName());
        this.deleteEmployee((JPO)jpOrm, employeeLocked);
        this.deleteEmployee((JPO)jpOrm, employeeUnlocked);
    }

    private Employee createEmployee(JPO jpOrm) {
        Session ormSession = jpOrm.session();
        Transaction tx = ormSession.transaction();
        int id = new Random().nextInt();
        Employee employee = new Employee();
        employee.setId(id);
        employee.setAge(44);
        employee.setEmployeeNumber("empNumber" + id);
        employee.setName("name");
        employee.setSurname("Cina");
        ormSession.save((Object)employee);
        tx.commit();
        return employee;
    }

    private void deleteEmployee(JPO jpOrm, Employee employee) {
        Session ormSession = jpOrm.session();
        Transaction tx = ormSession.transaction();
        ormSession.delete((Object)employee);
        tx.commit();
    }

    public class ActorLockForUpdate
    implements Runnable {
        private final JPO jpOrm;
        private final LockMode lockMode;
        private final String name;
        private final long employeeId;
        boolean exception = false;

        public ActorLockForUpdate(JPO jpOrm, long employeeId, LockMode lockMode, String name) {
            this.jpOrm = jpOrm;
            this.employeeId = employeeId;
            this.lockMode = lockMode;
            this.name = name;
        }

        @Override
        public void run() {
            System.out.println("Run: " + this.name);
            try {
                final Session session = this.jpOrm.session();
                Transaction tx = session.transaction();
                FindQuery query = session.findQuery(Employee.class);
                query.where().eq("Employee.id", (Object)this.employeeId);
                query.setLockMode(this.lockMode);
                System.out.println("Thread " + this.name + " executing query [" + query.renderSql() + "]");
                OrmRowMapper<Employee> srr = new OrmRowMapper<Employee>(){

                    public void read(Employee employee, int rowCount) {
                        System.out.println("Thread " + ActorLockForUpdate.this.name + " - employee.getName() = [" + employee.getName() + "]");
                        Assert.assertNotNull((Object)employee);
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        employee.setName(employee.getName() + "_" + ActorLockForUpdate.this.name);
                        System.out.println("Thread " + ActorLockForUpdate.this.name + " updating employee");
                        session.update((Object)employee);
                    }
                };
                query.find((OrmRowMapper)srr);
                tx.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.exception = true;
            }
        }
    }
}

