/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.script;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.query.find.FindQuery;
import com.jpattern.orm.script.ScriptExecutor;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.script.TempTable;
import com.jpattern.orm.transaction.Transaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ScriptExecutorTest
extends BaseTestShared {
    private String filename;

    @Override
    protected void setUp() throws Exception {
        this.filename = this.getTestInputBasePath() + "/StreamParserTest_1.sql";
        Assert.assertTrue((boolean)new File(this.filename).exists());
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testScript() throws Exception {
        this.executeScript((JPO)this.getJPOrm());
        this.verifyData((JPO)this.getJPOrm());
    }

    private void executeScript(JPO jpOrm) throws Exception {
        Session session = jpOrm.session();
        Transaction tx = session.transaction();
        ScriptExecutor scriptExecutor = session.scriptExecutor();
        FileInputStream scriptStream = new FileInputStream(this.filename);
        scriptExecutor.execute((InputStream)scriptStream);
        tx.commit();
    }

    private void verifyData(JPO jpOrm) throws Exception {
        jpOrm.register(TempTable.class);
        Session session = jpOrm.session();
        FindQuery query = session.findQuery(TempTable.class);
        query.orderBy().asc("TempTable.id");
        List result = query.findList();
        System.out.println("result.size() = " + result.size());
        Assert.assertTrue((result.size() == 11 ? 1 : 0) != 0);
        ArrayList<String> expectedResult = new ArrayList<String>();
        expectedResult.add("one");
        expectedResult.add("two");
        expectedResult.add("three");
        expectedResult.add("four;");
        expectedResult.add("f'ive;");
        expectedResult.add("s'ix;");
        expectedResult.add("seven';{--ix;");
        expectedResult.add("height';{--ix;");
        expectedResult.add("ni';ne';{--ix;");
        expectedResult.add("ten';{--ix;");
        expectedResult.add("e'le;{--ven;");
        for (int i = 0; i < result.size(); ++i) {
            TempTable temp = (TempTable)result.get(i);
            System.out.println("check element id: " + temp.getId() + " - name: " + temp.getName());
            Assert.assertEquals(expectedResult.get(i), (Object)temp.getName());
        }
    }
}

