/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.session;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.People_ConditionalGenerator;
import com.jpattern.orm.transaction.Transaction;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class SessionConditionalGeneratorTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailSavingASavedBean() throws Exception {
        JPOrm orm = this.getJPOrm();
        Session session = orm.session();
        Transaction tx = session.transaction();
        try {
            People_ConditionalGenerator people = new People_ConditionalGenerator();
            long originalId = people.getId();
            people.setFirstname("people name 1");
            people = (People_ConditionalGenerator)session.save((Object)people);
            Assert.assertFalse((people.getId() == originalId ? 1 : 0) != 0);
            Assert.assertTrue((people.getId() >= 0L ? 1 : 0) != 0);
            Assert.assertEquals((Object)"people name 1", (Object)((People_ConditionalGenerator)session.findUnique(People_ConditionalGenerator.class, (Object)1)).getFirstname());
            boolean error = false;
            try {
                people.setFirstname("people name 2");
                people = (People_ConditionalGenerator)session.save((Object)people);
                System.out.println("wrong saved id: " + people.getId());
                Assert.assertTrue((boolean)false);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("primary"));
                error = true;
            }
            Assert.assertTrue((boolean)error);
            Assert.assertEquals((Object)"people name 1", (Object)((People_ConditionalGenerator)session.findUnique(People_ConditionalGenerator.class, (Object)1)).getFirstname());
        }
        catch (Exception e) {
        }
        finally {
            tx.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSavingBeanWithArbitraryId() throws Exception {
        JPOrm orm = this.getJPOrm();
        Session session = orm.session();
        long id = new Random().nextInt();
        Transaction tx = session.transaction();
        try {
            People_ConditionalGenerator people = new People_ConditionalGenerator();
            people.setFirstname("people name 1");
            people.setId(id);
            people = (People_ConditionalGenerator)session.save((Object)people);
            System.out.println("saved id: " + people.getId());
            Assert.assertEquals((long)id, (long)people.getId());
            Assert.assertEquals((Object)"people name 1", (Object)((People_ConditionalGenerator)session.findUnique(People_ConditionalGenerator.class, (Object)id)).getFirstname());
            boolean error = false;
            try {
                People_ConditionalGenerator people2 = new People_ConditionalGenerator();
                people2.setFirstname("people name 2");
                people2.setId(id);
                people2 = (People_ConditionalGenerator)session.save((Object)people2);
                people2 = (People_ConditionalGenerator)session.save((Object)people2);
                System.out.println("wrong saved id: " + people2.getId());
                Assert.assertTrue((boolean)false);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("primary"));
                error = true;
            }
            Assert.assertTrue((boolean)error);
            Assert.assertEquals((Object)"people name 1", (Object)((People_ConditionalGenerator)session.findUnique(People_ConditionalGenerator.class, (Object)id)).getFirstname());
        }
        catch (Exception e) {
        }
        finally {
            tx.commit();
        }
    }
}

