/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.session;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.AutoId;
import com.jpattern.orm.test.domain.AutoIdInteger;
import com.jpattern.orm.test.domain.DataVersionWithoutGenerator;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.transaction.Transaction;
import java.util.Date;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class SessionSaveOrUpdateTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testSaveOrUpdateWithConditionGenerator() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        AutoId autoId = new AutoId();
        String value = "value for test " + new Date().getTime();
        autoId.setValue(value);
        int oldId = autoId.getId();
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        autoId = (AutoId)conn.saveOrUpdate((Object)autoId);
        int newId = autoId.getId();
        Assert.assertNotSame((Object)oldId, (Object)newId);
        Assert.assertEquals((Object)value, (Object)((AutoId)conn.find(AutoId.class, (Object)newId)).getValue());
        String newValue = "new value for test " + new Date().getTime();
        autoId.setValue(newValue);
        autoId = (AutoId)conn.saveOrUpdate((Object)autoId);
        Assert.assertEquals((long)newId, (long)autoId.getId());
        Assert.assertEquals((Object)newValue, (Object)((AutoId)conn.find(AutoId.class, (Object)newId)).getValue());
        tx.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveOrUpdateWithNotConditionGenerator() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        AutoIdInteger autoId = new AutoIdInteger();
        String value = "value for test " + new Date().getTime();
        autoId.setValue(value);
        Integer oldId = autoId.getId();
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        try {
            autoId = (AutoIdInteger)conn.saveOrUpdate((Object)autoId);
            Integer newId = autoId.getId();
            Assert.assertNotSame((Object)oldId, (Object)newId);
            Assert.assertEquals((Object)value, (Object)((AutoId)conn.find(AutoId.class, (Object)newId)).getValue());
            String newValue = "new value for test " + new Date().getTime();
            autoId.setValue(newValue);
            autoId = (AutoIdInteger)conn.saveOrUpdate((Object)autoId);
            Assert.assertEquals((Object)newId, (Object)autoId.getId());
            Assert.assertEquals((Object)newValue, (Object)((AutoId)conn.find(AutoId.class, (Object)newId)).getValue());
        }
        finally {
            tx.commit();
        }
    }

    @Test
    public void testSaveOrUpdateWithoutGenerator() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        int id = new Random().nextInt();
        Employee employee = new Employee();
        employee.setId(id);
        employee.setAge(44);
        employee.setEmployeeNumber("empNumber" + id);
        employee.setName("oldName");
        employee.setSurname("Cina");
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        employee = (Employee)conn.save((Object)employee);
        Assert.assertEquals((Object)"oldName", (Object)((Employee)conn.find(Employee.class, (Object)id)).getName());
        employee.setName("newName");
        employee = (Employee)conn.saveOrUpdate((Object)employee);
        Assert.assertEquals((Object)"newName", (Object)((Employee)conn.find(Employee.class, (Object)id)).getName());
        tx.commit();
    }

    @Test
    public void testSaveOrUpdateObjectWithVersionWithoutGenerator() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        Session conn = jpOrm.session();
        Transaction tx = conn.transaction();
        conn.deleteQuery(DataVersionWithoutGenerator.class);
        DataVersionWithoutGenerator bean = new DataVersionWithoutGenerator();
        int id = 1000;
        bean.setId(id);
        bean = (DataVersionWithoutGenerator)conn.saveOrUpdate((Object)bean);
        Assert.assertEquals((long)0L, (long)((DataVersionWithoutGenerator)conn.find(DataVersionWithoutGenerator.class, (Object)id)).getVersion());
        bean = (DataVersionWithoutGenerator)conn.saveOrUpdate((Object)bean);
        Assert.assertEquals((long)1L, (long)((DataVersionWithoutGenerator)conn.find(DataVersionWithoutGenerator.class, (Object)id)).getVersion());
        tx.commit();
    }
}

