/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.transaction;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPO;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.People;
import com.jpattern.orm.transaction.Transaction;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class JdbcTemplatePeopleTest
extends BaseTestShared {
    @Override
    protected void setUp() throws Exception {
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testJdbcTemplateTransaction1() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(People.class);
        Transaction tx = jpOrm.session().transaction();
        long id = this.create((JPO)jpOrm);
        tx.commit();
        tx = jpOrm.session().transaction();
        People loaded = this.load((JPO)jpOrm, id);
        tx.commit();
        Assert.assertNotNull((Object)loaded);
        tx = jpOrm.session().transaction();
        this.delete((JPO)jpOrm, loaded);
        tx.rollback();
        tx = jpOrm.session().transaction();
        loaded = this.load((JPO)jpOrm, id);
        tx.commit();
        Assert.assertNotNull((Object)loaded);
        tx = jpOrm.session().transaction();
        this.delete((JPO)jpOrm, loaded);
        tx.setRollbackOnly();
        tx.commit();
        tx = jpOrm.session().transaction();
        loaded = this.load((JPO)jpOrm, id);
        tx.commit();
        Assert.assertNotNull((Object)loaded);
        tx = jpOrm.session().transaction();
        this.delete((JPO)jpOrm, loaded);
        tx.commit();
        tx = jpOrm.session().transaction();
        loaded = this.load((JPO)jpOrm, id);
        tx.commit();
        Assert.assertNull((Object)loaded);
    }

    private long create(JPO jpOrm) throws Exception {
        long id = new Date().getTime();
        People people = new People();
        people.setId(id);
        people.setFirstname("people");
        people.setLastname("Wizard");
        Session conn = jpOrm.session();
        people = (People)conn.save((Object)people);
        System.out.println("People saved with id: " + people.getId());
        Assert.assertFalse((id == people.getId() ? 1 : 0) != 0);
        return people.getId();
    }

    private People load(JPO jpOrm, long id) throws Exception {
        Session conn = jpOrm.session();
        People peopleLoad1 = (People)conn.find(People.class, new Object[]{id});
        return peopleLoad1;
    }

    private void delete(JPO jpOrm, People people) throws Exception {
        Session conn = jpOrm.session();
        conn.delete((Object)people);
    }
}

