/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.transaction;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.session.TransactionCallback;
import com.jpattern.orm.test.domain.Employee;
import com.jpattern.orm.transaction.Transaction;
import java.util.ArrayList;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class TransactionCallbackTest
extends BaseTestShared {
    private final int repeatTests = 50;
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.session = this.getJPOrm().session();
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testTransactionCommitted() throws Exception {
        final Random random = new Random();
        final ArrayList employees = new ArrayList();
        for (int i = 0; i < this.repeatTests; ++i) {
            this.session.doInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction(Session session) {
                    Employee employee = new Employee();
                    employee.setId(random.nextInt());
                    employees.add(employee);
                    session.save((Object)employee);
                    return null;
                }
            });
        }
        for (Employee employee : employees) {
            Assert.assertNotNull((Object)this.session.find(Employee.class, (Object)employee.getId()));
        }
    }

    @Test
    public void testTransactionRolledback() throws Exception {
        final Random random = new Random();
        final ArrayList employees = new ArrayList();
        for (int i = 0; i < this.repeatTests; ++i) {
            try {
                this.session.doInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                    public Void doInTransaction(Session session) {
                        Employee employee = new Employee();
                        employee.setId(random.nextInt());
                        employees.add(employee);
                        session.save((Object)employee);
                        throw new RuntimeException("manually thrown exception");
                    }
                });
                continue;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        for (Employee employee : employees) {
            Assert.assertNull((Object)this.session.find(Employee.class, (Object)employee.getId()));
        }
    }

    @Test
    public void testPartecipatingInExistingTransaction() throws Exception {
        final Random random = new Random();
        final ArrayList employees = new ArrayList();
        Transaction tx = this.session.transaction();
        for (int i = 0; i < this.repeatTests; ++i) {
            this.session.doInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction(Session session) {
                    Employee employee = new Employee();
                    employee.setId(random.nextInt());
                    employees.add(employee);
                    session.save((Object)employee);
                    return null;
                }
            });
        }
        tx.rollback();
        for (Employee employee : employees) {
            Assert.assertNull((Object)this.session.find(Employee.class, (Object)employee.getId()));
        }
    }

    @Test
    public void testPartecipatingInExistingTransactionAndRollback() throws Exception {
        final Random random = new Random();
        final ArrayList employees = new ArrayList();
        Transaction tx = this.session.transaction();
        for (int i = 0; i < this.repeatTests; ++i) {
            this.session.doInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction(Session session) {
                    Employee employee = new Employee();
                    employee.setId(random.nextInt());
                    employees.add(employee);
                    session.save((Object)employee);
                    return null;
                }
            });
        }
        try {
            this.session.doInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction(Session session) {
                    Employee employee = new Employee();
                    employee.setId(random.nextInt());
                    employees.add(employee);
                    session.save((Object)employee);
                    throw new RuntimeException("manually thrown exception");
                }
            });
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            tx.commit();
            Assert.fail();
        }
        catch (OrmException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("rollback"));
        }
        for (Employee employee : employees) {
            Assert.assertNull((Object)this.session.find(Employee.class, (Object)employee.getId()));
        }
    }
}

