/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.test.version;

import com.jpattern.orm.BaseTestShared;
import com.jpattern.orm.JPOrm;
import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.exception.OrmOptimisticLockException;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.test.domain.DataVersionInteger;
import com.jpattern.orm.test.domain.DataVersionLong;
import com.jpattern.orm.test.domain.DataVersionSqlDate;
import com.jpattern.orm.transaction.Transaction;
import org.junit.Assert;
import org.junit.Test;

public class VersionTest
extends BaseTestShared {
    private Session session;

    @Override
    protected void setUp() throws Exception {
        JPOrm jpOrm = this.getJPOrm();
        jpOrm.register(DataVersionInteger.class);
        jpOrm.register(DataVersionLong.class);
        this.session = jpOrm.session();
    }

    @Override
    protected void tearDown() throws Exception {
    }

    @Test
    public void testLongNewRecordVersion() throws Exception {
        DataVersionLong dataVersion = new DataVersionLong();
        dataVersion.setData("dataVersion1");
        Transaction tx = this.session.transaction();
        dataVersion = (DataVersionLong)this.session.save((Object)dataVersion);
        long currentVersion = dataVersion.getVersion();
        Assert.assertEquals((long)0L, (long)currentVersion);
        tx.commit();
        tx = this.session.transaction();
        dataVersion = (DataVersionLong)this.session.update((Object)dataVersion);
        Assert.assertEquals((long)(currentVersion + 1L), (long)dataVersion.getVersion());
        tx.commit();
        tx = this.session.transaction();
        dataVersion = (DataVersionLong)this.session.update((Object)dataVersion);
        Assert.assertEquals((long)(currentVersion + 2L), (long)dataVersion.getVersion());
        tx.commit();
    }

    @Test
    public void testLongNewRecordVersionWithCustomVersionNumber() throws Exception {
        DataVersionLong dataVersion = new DataVersionLong();
        dataVersion.setData("dataVersion1");
        dataVersion.setVersion(1000L);
        Transaction tx = this.session.transaction();
        dataVersion = (DataVersionLong)this.session.save((Object)dataVersion);
        long currentVersion = dataVersion.getVersion();
        Assert.assertEquals((long)0L, (long)currentVersion);
        tx.commit();
        tx = this.session.transaction();
        dataVersion = (DataVersionLong)this.session.update((Object)dataVersion);
        Assert.assertEquals((long)(currentVersion + 1L), (long)dataVersion.getVersion());
        tx.commit();
        tx = this.session.transaction();
        dataVersion = (DataVersionLong)this.session.update((Object)dataVersion);
        Assert.assertEquals((long)(currentVersion + 2L), (long)dataVersion.getVersion());
        tx.commit();
    }

    @Test
    public void testLongWrongVersionNumber() throws Exception {
        DataVersionLong dataVersion = new DataVersionLong();
        dataVersion.setData("dataVersion1");
        dataVersion.setVersion(1000L);
        Transaction tx = this.session.transaction();
        dataVersion = (DataVersionLong)this.session.save((Object)dataVersion);
        long currentVersion = dataVersion.getVersion();
        Assert.assertEquals((long)0L, (long)currentVersion);
        tx.commit();
        tx = this.session.transaction();
        dataVersion = (DataVersionLong)this.session.update((Object)dataVersion);
        Assert.assertEquals((long)(currentVersion + 1L), (long)dataVersion.getVersion());
        tx.commit();
        tx = this.session.transaction();
        boolean wrongVersion = false;
        try {
            dataVersion.setVersion(1000L);
            dataVersion = (DataVersionLong)this.session.update((Object)dataVersion);
        }
        catch (OrmOptimisticLockException e) {
            e.printStackTrace();
            wrongVersion = true;
        }
        Assert.assertTrue((boolean)wrongVersion);
        tx.commit();
    }

    @Test
    public void testSqlDateNewRecordVersion() throws Exception {
        try {
            this.getJPOrm().register(DataVersionSqlDate.class);
            Assert.fail((String)"A OrmConfigurationException should be thrwon before!!");
        }
        catch (OrmConfigurationException ormConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testIntegerNewRecordVersion() throws Exception {
        DataVersionInteger dataVersion = new DataVersionInteger();
        dataVersion.setData("dataVersion1");
        Assert.assertNull((Object)dataVersion.getVersion());
        Transaction tx = this.session.transaction();
        dataVersion = (DataVersionInteger)this.session.save((Object)dataVersion);
        Integer currentVersion = dataVersion.getVersion();
        Assert.assertEquals((Object)0, (Object)currentVersion);
        tx.commit();
        tx = this.session.transaction();
        dataVersion = (DataVersionInteger)this.session.update((Object)dataVersion);
        Assert.assertEquals((Object)(currentVersion + 1), (Object)dataVersion.getVersion());
        tx.commit();
        tx = this.session.transaction();
        boolean wrongVersion = false;
        try {
            dataVersion.setVersion(1000);
            dataVersion = (DataVersionInteger)this.session.update((Object)dataVersion);
        }
        catch (OrmOptimisticLockException e) {
            e.printStackTrace();
            wrongVersion = true;
        }
        Assert.assertTrue((boolean)wrongVersion);
        tx.commit();
    }
}

