/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.compute;

import com.stripe.rainier.compute.Bounds;
import com.stripe.rainier.compute.Log$;
import com.stripe.rainier.compute.Real;
import com.stripe.rainier.compute.Real$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Bounds$
implements Serializable {
    public static final Bounds$ MODULE$ = new Bounds$();

    public Bounds or(Seq<Bounds> seq) {
        return new Bounds(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)seq.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.lower()))).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)seq.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.upper()))).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
    }

    public Bounds sum(Seq<Bounds> seq) {
        return new Bounds(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)seq.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.lower()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)seq.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.upper()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
    }

    public Bounds multiply(Bounds left, Bounds right) {
        List options = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{this.multiply(left.lower(), right.lower()), this.multiply(left.lower(), right.upper()), this.multiply(left.upper(), right.lower()), this.multiply(left.upper(), right.upper())}));
        return new Bounds(BoxesRunTime.unboxToDouble((Object)options.min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)options.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
    }

    private double multiply(double left, double right) {
        return Double.isInfinite(left) && right == 0.0 ? left : (left == 0.0 && Double.isInfinite(right) ? right : left * right);
    }

    public Bounds pow(Bounds x, Bounds y) {
        return y.lower() >= 0.0 ? this.positivePow(x, y) : (y.upper() <= 0.0 ? this.negativePow(x, y) : this.or((Seq<Bounds>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bounds[]{this.negativePow(x, new Bounds(y.lower(), 0.0)), this.positivePow(x, new Bounds(0.0, y.upper()))})))));
    }

    private Bounds positivePow(Bounds x, Bounds y) {
        return x.lower() >= 0.0 ? this.positivePositivePow(x, y) : (x.upper() <= 0.0 ? this.negativePositivePow(x, y) : this.or((Seq<Bounds>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bounds[]{this.negativePositivePow(new Bounds(x.lower(), 0.0), y), this.positivePositivePow(new Bounds(0.0, x.upper()), y)})))));
    }

    private Bounds negativePow(Bounds x, Bounds y) {
        return this.reciprocal(this.positivePow(x, new Bounds(y.lower() * (double)-1, y.upper() * (double)-1)));
    }

    private Bounds positivePositivePow(Bounds x, Bounds y) {
        List options = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{Math.pow(x.lower(), y.lower()), Math.pow(x.lower(), y.upper()), Math.pow(x.upper(), y.lower()), Math.pow(x.upper(), y.upper())}));
        return new Bounds(BoxesRunTime.unboxToDouble((Object)options.min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)options.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
    }

    private Bounds negativePositivePow(Bounds x, Bounds y) {
        Bounds bounds;
        if (y.lower() == y.upper() && RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(y.lower()))) {
            List options = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{Math.pow(x.lower(), y.lower()), Math.pow(x.upper(), y.lower())}));
            bounds = new Bounds(BoxesRunTime.unboxToDouble((Object)options.min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)options.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
        } else {
            bounds = new Bounds(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        return bounds;
    }

    public Bounds reciprocal(Bounds x) {
        return x.lower() <= 0.0 && x.upper() >= 0.0 ? new Bounds(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY) : new Bounds(1.0 / x.upper(), 1.0 / x.lower());
    }

    public Bounds abs(Bounds x) {
        Bounds bounds;
        if (x.lower() <= 0.0 && x.upper() >= 0.0) {
            bounds = new Bounds(0.0, RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(Math.abs(x.lower())), x.upper()));
        } else {
            List options = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{Math.abs(x.lower()), Math.abs(x.upper())}));
            bounds = new Bounds(BoxesRunTime.unboxToDouble((Object)options.min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)), BoxesRunTime.unboxToDouble((Object)options.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
        }
        return bounds;
    }

    public Bounds log(Bounds x) {
        return new Bounds(Math.log(x.lower()), Math.log(x.upper()));
    }

    public Bounds exp(Bounds x) {
        return new Bounds(Math.exp(x.lower()), Math.exp(x.upper()));
    }

    public Real positive(Real value, Function0<Real> calc) {
        Real real;
        if (this.test(value, (Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable)x$5 -> x$5 >= 0.0)) {
            real = (Real)calc.apply();
        } else {
            this.warn(value, "x >= 0");
            real = Real$.MODULE$.gte(value, Real$.MODULE$.zero(), (Real)calc.apply(), Real$.MODULE$.negInfinity());
        }
        return real;
    }

    public Real zeroToOne(Real value, Function0<Real> calc) {
        Real real;
        if (this.test(value, (Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable)v -> v >= 0.0 && v <= 1.0)) {
            real = (Real)calc.apply();
        } else {
            this.warn(value, "0 <= x <= 1");
            real = Real$.MODULE$.gte(value, Real$.MODULE$.zero(), Real$.MODULE$.lte(value, Real$.MODULE$.one(), (Real)calc.apply(), Real$.MODULE$.negInfinity()), Real$.MODULE$.negInfinity());
        }
        return real;
    }

    public boolean test(Real value, Function1<Object, Object> fn) {
        return fn.apply$mcZD$sp(value.bounds().lower()) && fn.apply$mcZD$sp(value.bounds().upper());
    }

    public void check(Real value, String description, Function1<Object, Object> fn) {
        block0: {
            if (this.test(value, fn)) break block0;
            this.warn(value, description);
        }
    }

    private void warn(Real value, String description) {
        Log$.MODULE$.WARNING().log("Couldn't prove %s for bounds (%f,%f)", (Object)description, (Object)BoxesRunTime.boxToDouble((double)value.bounds().lower()), (Object)BoxesRunTime.boxToDouble((double)value.bounds().upper()));
    }

    public Bounds apply(double lower, double upper) {
        return new Bounds(lower, upper);
    }

    public Option<Tuple2<Object, Object>> unapply(Bounds x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2.mcDD.sp(x$0.lower(), x$0.upper()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Bounds$.class);
    }

    private Bounds$() {
    }
}

