/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.compute;

import com.stripe.rainier.compute.Constant;
import com.stripe.rainier.compute.Constant$;
import com.stripe.rainier.ir.AbsOp$;
import com.stripe.rainier.ir.AcosOp$;
import com.stripe.rainier.ir.AsinOp$;
import com.stripe.rainier.ir.AtanOp$;
import com.stripe.rainier.ir.CosOp$;
import com.stripe.rainier.ir.ExpOp$;
import com.stripe.rainier.ir.LogOp$;
import com.stripe.rainier.ir.NoOp$;
import com.stripe.rainier.ir.SinOp$;
import com.stripe.rainier.ir.TanOp$;
import com.stripe.rainier.ir.UnaryOp;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class ConstantOps$ {
    public static final ConstantOps$ MODULE$ = new ConstantOps$();

    public Constant unary(Constant original, UnaryOp op) {
        Constant constant;
        if (original.isPosInfinity()) {
            Constant constant2;
            UnaryOp unaryOp = op;
            if (ExpOp$.MODULE$.equals(unaryOp)) {
                constant2 = Constant$.MODULE$.Infinity();
            } else if (LogOp$.MODULE$.equals(unaryOp)) {
                constant2 = Constant$.MODULE$.Infinity();
            } else if (AbsOp$.MODULE$.equals(unaryOp)) {
                constant2 = Constant$.MODULE$.Infinity();
            } else {
                if (SinOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("No limit for 'sin' at positive infinity");
                }
                if (CosOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("No limit for 'cos' at positive infinity");
                }
                if (TanOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("No limit for 'tan' at positive infinity");
                }
                if (AcosOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("acos undefined above 1");
                }
                if (AsinOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("asin undefined above 1");
                }
                if (AtanOp$.MODULE$.equals(unaryOp)) {
                    constant2 = Constant$.MODULE$.Pi().$div(Constant$.MODULE$.Two());
                } else if (NoOp$.MODULE$.equals(unaryOp)) {
                    constant2 = Constant$.MODULE$.Infinity();
                } else {
                    throw new MatchError((Object)unaryOp);
                }
            }
            constant = constant2;
        } else if (original.isNegInfinity()) {
            Constant constant3;
            UnaryOp unaryOp = op;
            if (ExpOp$.MODULE$.equals(unaryOp)) {
                constant3 = Constant$.MODULE$.Zero();
            } else {
                if (LogOp$.MODULE$.equals(unaryOp)) {
                    throw new ArithmeticException("Cannot take the log of a negative number");
                }
                if (AbsOp$.MODULE$.equals(unaryOp)) {
                    constant3 = Constant$.MODULE$.Infinity();
                } else {
                    if (SinOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("No limit for 'sin' at negative infinity");
                    }
                    if (CosOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("No limit for 'cos' at negative infinity");
                    }
                    if (TanOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("No limit for 'tan' at negative infinity");
                    }
                    if (AcosOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("acos undefined below -1");
                    }
                    if (AsinOp$.MODULE$.equals(unaryOp)) {
                        throw new ArithmeticException("asin undefined below -1");
                    }
                    if (AtanOp$.MODULE$.equals(unaryOp)) {
                        constant3 = Constant$.MODULE$.Pi().$div(Constant$.MODULE$.NegTwo());
                    } else if (NoOp$.MODULE$.equals(unaryOp)) {
                        constant3 = original;
                    } else {
                        throw new MatchError((Object)unaryOp);
                    }
                }
            }
            constant = constant3;
        } else if (original.isZero()) {
            Constant constant4;
            UnaryOp unaryOp = op;
            if (ExpOp$.MODULE$.equals(unaryOp)) {
                constant4 = Constant$.MODULE$.One();
            } else if (LogOp$.MODULE$.equals(unaryOp)) {
                constant4 = Constant$.MODULE$.NegInfinity();
            } else if (AbsOp$.MODULE$.equals(unaryOp)) {
                constant4 = Constant$.MODULE$.Zero();
            } else if (SinOp$.MODULE$.equals(unaryOp)) {
                constant4 = Constant$.MODULE$.Zero();
            } else if (CosOp$.MODULE$.equals(unaryOp)) {
                constant4 = Constant$.MODULE$.One();
            } else if (TanOp$.MODULE$.equals(unaryOp)) {
                constant4 = Constant$.MODULE$.Zero();
            } else if (AsinOp$.MODULE$.equals(unaryOp)) {
                constant4 = Constant$.MODULE$.Zero();
            } else if (AcosOp$.MODULE$.equals(unaryOp)) {
                constant4 = Constant$.MODULE$.Pi().$div(Constant$.MODULE$.Two());
            } else if (AtanOp$.MODULE$.equals(unaryOp)) {
                constant4 = Constant$.MODULE$.Zero();
            } else if (NoOp$.MODULE$.equals(unaryOp)) {
                constant4 = original;
            } else {
                throw new MatchError((Object)unaryOp);
            }
            constant = constant4;
        } else {
            Constant constant5;
            UnaryOp unaryOp = op;
            if (ExpOp$.MODULE$.equals(unaryOp)) {
                constant5 = original.map((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x$1 -> Math.exp(x$1));
            } else if (LogOp$.MODULE$.equals(unaryOp)) {
                if (!original.isPositive()) {
                    throw new ArithmeticException("Cannot take the log of a negative number");
                }
                constant5 = original.map((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x$1 -> Math.log(x$1));
            } else if (AbsOp$.MODULE$.equals(unaryOp)) {
                constant5 = original.map((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x$1 -> Math.abs(x$1));
            } else if (SinOp$.MODULE$.equals(unaryOp)) {
                constant5 = original.map((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x$1 -> Math.sin(x$1));
            } else if (CosOp$.MODULE$.equals(unaryOp)) {
                constant5 = original.map((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x$1 -> Math.cos(x$1));
            } else if (TanOp$.MODULE$.equals(unaryOp)) {
                constant5 = original.map((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x$1 -> Math.tan(x$1));
            } else if (AsinOp$.MODULE$.equals(unaryOp)) {
                constant5 = original.map((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x$1 -> Math.asin(x$1));
            } else if (AcosOp$.MODULE$.equals(unaryOp)) {
                constant5 = original.map((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x$1 -> Math.acos(x$1));
            } else if (AtanOp$.MODULE$.equals(unaryOp)) {
                constant5 = original.map((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)x$1 -> Math.atan(x$1));
            } else if (NoOp$.MODULE$.equals(unaryOp)) {
                constant5 = original;
            } else {
                throw new MatchError((Object)unaryOp);
            }
            constant = constant5;
        }
        return constant;
    }

    public Constant add(Constant left, Constant right) {
        if (left.isNegInfinity() && right.isPosInfinity() || left.isPosInfinity() && right.isNegInfinity()) {
            throw new ArithmeticException("Cannot add +inf and -inf");
        }
        return left.mapWith(right, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(x$1, x$2) -> x$1 + x$2);
    }

    public Constant multiply(Constant left, Constant right) {
        if ((left.isPosInfinity() || left.isNegInfinity()) && right.isZero() || left.isZero() && (right.isPosInfinity() || right.isNegInfinity())) {
            throw new ArithmeticException("Cannot multiply inf by zero");
        }
        return left.mapWith(right, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(x$3, x$4) -> x$3 * x$4);
    }

    public Constant divide(Constant left, Constant right) {
        if (left.isZero() && right.isZero()) {
            throw new ArithmeticException("Cannot divide zero by zero");
        }
        return left.mapWith(right, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(x$5, x$6) -> x$5 / x$6);
    }

    public Constant pow(Constant left, Constant right) {
        return left.mapWith(right, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(x, y) -> Math.pow(x, y));
    }

    public Constant compare(Constant left, Constant right) {
        return left.mapWith(right, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(a, b) -> a == b || RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(a)) && RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(b)) || RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(a)) && RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(b)) ? 0.0 : (a < b || RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(a)) || RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(b)) ? -1.0 : 1.0));
    }

    private ConstantOps$() {
    }
}

