/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.compute;

import com.stripe.rainier.compute.Compare;
import com.stripe.rainier.compute.Constant;
import com.stripe.rainier.compute.Line;
import com.stripe.rainier.compute.LogLine;
import com.stripe.rainier.compute.Lookup;
import com.stripe.rainier.compute.NonConstant;
import com.stripe.rainier.compute.Parameter;
import com.stripe.rainier.compute.Pow;
import com.stripe.rainier.compute.Real;
import com.stripe.rainier.compute.Real$;
import com.stripe.rainier.compute.RealOps$;
import com.stripe.rainier.compute.ToReal$;
import com.stripe.rainier.compute.Unary;
import com.stripe.rainier.ir.UnaryOp;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0005I4A\u0001E\t\u00015!A\u0011\u0005\u0001BA\u0002\u0013\u0005!\u0005\u0003\u00056\u0001\t\u0005\r\u0011\"\u00017\u0011!a\u0004A!A!B\u0013\u0019\u0003\"B\u001f\u0001\t\u0003q\u0004\"B!\u0001\t\u0003\u0011\u0005\"B#\u0001\t\u00131\u0005\"B%\u0001\t\u0003Q\u0005\"B)\u0001\t\u0003\u0011\u0006\"\u0002+\u0001\t\u0003)\u0006\"\u0002-\u0001\t\u0003I\u0006\"B.\u0001\t\u0003a\u0006\"B0\u0001\t\u0003\u0001\u0007\"B2\u0001\t\u0003!\u0007\"B5\u0001\t\u0003Q\u0007\"\u00027\u0001\t\u0003i'!C#wC2,\u0018\r^8s\u0015\t\u00112#A\u0004d_6\u0004X\u000f^3\u000b\u0005Q)\u0012a\u0002:bS:LWM\u001d\u0006\u0003-]\taa\u001d;sSB,'\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g-A\u0003dC\u000eDW-F\u0001$!\u0011!3F\f\u001a\u000f\u0005\u0015J\u0003C\u0001\u0014\u001e\u001b\u00059#B\u0001\u0015\u001a\u0003\u0019a$o\\8u}%\u0011!&H\u0001\u0007!J,G-\u001a4\n\u00051j#aA'ba*\u0011!&\b\t\u0003_Aj\u0011!E\u0005\u0003cE\u0011AAU3bYB\u0011AdM\u0005\u0003iu\u0011a\u0001R8vE2,\u0017!C2bG\",w\fJ3r)\t9$\b\u0005\u0002\u001dq%\u0011\u0011(\b\u0002\u0005+:LG\u000fC\u0004<\u0005\u0005\u0005\t\u0019A\u0012\u0002\u0007a$\u0013'\u0001\u0004dC\u000eDW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\u0002\u0005CA\u0018\u0001\u0011\u0015\tC\u00011\u0001$\u0003!!x\u000eR8vE2,GC\u0001\u001aD\u0011\u0015!U\u00011\u0001/\u0003\u0005A\u0018\u0001B3wC2$\"AM$\t\u000b!3\u0001\u0019\u0001\u0018\u0002\tI,\u0017\r\\\u0001\bG>l\u0007/\u0019:f)\rYej\u0014\t\u000391K!!T\u000f\u0003\u0007%sG\u000fC\u0003E\u000f\u0001\u0007a\u0006C\u0003Q\u000f\u0001\u0007a&A\u0001z\u0003\u001d1'o\\7J]R$\"AL*\t\u000b\u0011C\u0001\u0019A&\u0002\u000b5Lg.^:\u0015\u000792v\u000bC\u0003E\u0013\u0001\u0007a\u0006C\u0003Q\u0013\u0001\u0007a&\u0001\u0004oK\u001e\fG/\u001a\u000b\u0003]iCQ\u0001\u0012\u0006A\u00029\nA\u0001\u001d7vgR\u0019a&\u00180\t\u000b\u0011[\u0001\u0019\u0001\u0018\t\u000bA[\u0001\u0019\u0001\u0018\u0002\u000bQLW.Z:\u0015\u00079\n'\rC\u0003E\u0019\u0001\u0007a\u0006C\u0003Q\u0019\u0001\u0007a&A\u0004u_\u001acw.\u0019;\u0015\u0005\u0015D\u0007C\u0001\u000fg\u0013\t9WDA\u0003GY>\fG\u000fC\u0003E\u001b\u0001\u0007a&A\u0003u_&sG\u000f\u0006\u0002LW\")AI\u0004a\u0001]\u00051Ao\u001c'p]\u001e$\"A\\9\u0011\u0005qy\u0017B\u00019\u001e\u0005\u0011auN\\4\t\u000b\u0011{\u0001\u0019\u0001\u0018")
public class Evaluator {
    private Map<Real, Object> cache;

    public Map<Real, Object> cache() {
        return this.cache;
    }

    public void cache_$eq(Map<Real, Object> x$1) {
        this.cache = x$1;
    }

    public double toDouble(Real x) {
        double d;
        Real real = x;
        if (real instanceof Constant) {
            Constant constant = (Constant)real;
            d = constant.getDouble();
        } else {
            double d2;
            Option option = this.cache().get((Object)x);
            if (option instanceof Some) {
                double v;
                Some some = (Some)option;
                d2 = v = BoxesRunTime.unboxToDouble((Object)some.value());
            } else if (None$.MODULE$.equals(option)) {
                double v = this.eval(x);
                this.cache_$eq((Map<Real, Object>)((Map)this.cache().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x), (Object)BoxesRunTime.boxToDouble((double)v)))));
                d2 = v;
            } else {
                throw new MatchError((Object)option);
            }
            d = d2;
        }
        return d;
    }

    private double eval(Real real) {
        double d;
        block10: {
            Real real2;
            while (true) {
                if ((real2 = real) instanceof Constant) {
                    Constant constant = (Constant)real2;
                    d = constant.getDouble();
                    break block10;
                }
                if (real2 instanceof Line) {
                    Line line = (Line)real2;
                    d = BoxesRunTime.unboxToDouble((Object)line.ax().toList().map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)Evaluator.$anonfun$eval$1(this, x0$1))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) + line.b().getDouble();
                    break block10;
                }
                if (real2 instanceof LogLine) {
                    LogLine logLine = (LogLine)real2;
                    d = BoxesRunTime.unboxToDouble((Object)logLine.ax().toList().map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)Evaluator.$anonfun$eval$2(this, x0$2))).product((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                    break block10;
                }
                if (real2 instanceof Unary) {
                    Unary unary = (Unary)real2;
                    NonConstant original = unary.original();
                    UnaryOp op = unary.op();
                    Real ev = Real$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toDouble(original)), ToReal$.MODULE$.numeric(Numeric.DoubleIsFractional$.MODULE$));
                    real = RealOps$.MODULE$.unary(ev, op);
                    continue;
                }
                if (!(real2 instanceof Compare)) break;
                Compare compare = (Compare)real2;
                Real left = compare.left();
                Real right = compare.right();
                real = RealOps$.MODULE$.compare(Real$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toDouble(left)), ToReal$.MODULE$.numeric(Numeric.DoubleIsFractional$.MODULE$)), Real$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toDouble(right)), ToReal$.MODULE$.numeric(Numeric.DoubleIsFractional$.MODULE$)));
            }
            if (real2 instanceof Pow) {
                Pow pow = (Pow)real2;
                Real base = pow.base();
                NonConstant exponent = pow.exponent();
                d = Math.pow(this.toDouble(base), this.toDouble(exponent));
            } else if (real2 instanceof Lookup) {
                Lookup lookup = (Lookup)real2;
                d = this.toDouble(lookup.table()[(int)this.toDouble(lookup.index()) - lookup.low()]);
            } else {
                if (real2 instanceof Parameter) {
                    Parameter parameter = (Parameter)real2;
                    throw package$.MODULE$.error(new StringBuilder(22).append("No value provided for ").append(parameter).toString());
                }
                throw new MatchError((Object)real2);
            }
        }
        return d;
    }

    public int compare(Real x, Real y) {
        return new RichDouble(Predef$.MODULE$.doubleWrapper(this.toDouble(x))).compare((Object)BoxesRunTime.boxToDouble((double)this.toDouble(y)));
    }

    public Real fromInt(int x) {
        return Real$.MODULE$.apply(BoxesRunTime.boxToInteger((int)x), ToReal$.MODULE$.fromInt());
    }

    public Real minus(Real x, Real y) {
        return x.$minus(y);
    }

    public Real negate(Real x) {
        return x.$times(Real$.MODULE$.apply(BoxesRunTime.boxToInteger((int)-1), ToReal$.MODULE$.fromInt()));
    }

    public Real plus(Real x, Real y) {
        return x.$plus(y);
    }

    public Real times(Real x, Real y) {
        return x.$times(y);
    }

    public float toFloat(Real x) {
        return (float)this.toDouble(x);
    }

    public int toInt(Real x) {
        return (int)this.toDouble(x);
    }

    public long toLong(Real x) {
        return (long)this.toDouble(x);
    }

    public static final /* synthetic */ double $anonfun$eval$1(Evaluator $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        NonConstant r = (NonConstant)tuple2._1();
        Constant d = (Constant)tuple2._2();
        double d2 = $this.toDouble(r) * d.getDouble();
        return d2;
    }

    public static final /* synthetic */ double $anonfun$eval$2(Evaluator $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        NonConstant r = (NonConstant)tuple2._1();
        Constant d = (Constant)tuple2._2();
        double d2 = Math.pow($this.toDouble(r), d.getDouble());
        return d2;
    }

    public Evaluator(Map<Real, Object> cache) {
        this.cache = cache;
    }
}

