/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.compute;

import com.stripe.rainier.compute.Coefficients;
import com.stripe.rainier.compute.Coefficients$;
import com.stripe.rainier.compute.Constant;
import com.stripe.rainier.compute.Constant$;
import com.stripe.rainier.compute.Line;
import com.stripe.rainier.compute.Line$;
import com.stripe.rainier.compute.LogLine;
import com.stripe.rainier.compute.LogLineOps$;
import com.stripe.rainier.compute.NonConstant;
import com.stripe.rainier.compute.Real;
import com.stripe.rainier.compute.Real$;
import com.stripe.rainier.compute.RealOps$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;

public final class LineOps$ {
    public static final LineOps$ MODULE$ = new LineOps$();

    private Tuple2<Coefficients, Constant> axb(NonConstant nc) {
        Tuple2 tuple2;
        NonConstant nonConstant = nc;
        if (nonConstant instanceof Line) {
            Line line = (Line)nonConstant;
            tuple2 = new Tuple2((Object)line.ax(), (Object)line.b());
        } else if (nonConstant instanceof LogLine) {
            LogLine logLine = (LogLine)nonConstant;
            tuple2 = (Tuple2)LogLineOps$.MODULE$.distribute(logLine).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)Coefficients$.MODULE$.apply(logLine), (Object)Constant$.MODULE$.Zero()));
        } else {
            tuple2 = new Tuple2((Object)Coefficients$.MODULE$.apply(nc), (Object)Constant$.MODULE$.Zero());
        }
        return tuple2;
    }

    public Real sum(NonConstant left, NonConstant right) {
        Tuple2<Coefficients, Constant> tuple2 = this.axb(left);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Coefficients lax = (Coefficients)tuple2._1();
        Constant lb = (Constant)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lax, (Object)lb);
        Tuple2 tuple23 = tuple22;
        Coefficients lax2 = (Coefficients)tuple23._1();
        Constant lb2 = (Constant)tuple23._2();
        Tuple2<Coefficients, Constant> tuple24 = this.axb(right);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        Coefficients rax = (Coefficients)tuple24._1();
        Constant rb = (Constant)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)rax, (Object)rb);
        Tuple2 tuple26 = tuple25;
        Coefficients rax2 = (Coefficients)tuple26._1();
        Constant rb2 = (Constant)tuple26._2();
        Coefficients merged = lax2.merge(rax2);
        return merged.isEmpty() ? lb2.$plus(rb2) : this.simplify(merged, lb2.$plus(rb2));
    }

    public Real scale(NonConstant nc, Constant v) {
        Tuple2<Coefficients, Constant> tuple2 = this.axb(nc);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Coefficients ax = (Coefficients)tuple2._1();
        Constant b = (Constant)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)ax, (Object)b);
        Tuple2 tuple23 = tuple22;
        Coefficients ax2 = (Coefficients)tuple23._1();
        Constant b2 = (Constant)tuple23._2();
        return this.simplify(ax2.mapCoefficients((Function1<Constant, Constant>)(Function1 & Serializable)x$4 -> x$4.$times(v)), b2.$times(v));
    }

    public Real translate(NonConstant nc, Constant v) {
        Tuple2<Coefficients, Constant> tuple2 = this.axb(nc);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Coefficients ax = (Coefficients)tuple2._1();
        Constant b = (Constant)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)ax, (Object)b);
        Tuple2 tuple23 = tuple22;
        Coefficients ax2 = (Coefficients)tuple23._1();
        Constant b2 = (Constant)tuple23._2();
        return this.simplify(ax2, b2.$plus(v));
    }

    public Line multiply(Line left, Line right) {
        Tuple2 tuple2 = new Tuple2((Object)Real$.MODULE$.one(), (Object)left.b());
        List allLeft = left.ax().toList().$colon$colon((Object)tuple2);
        Tuple2 tuple22 = new Tuple2((Object)Real$.MODULE$.one(), (Object)right.b());
        List allRight = right.ax().toList().$colon$colon((Object)tuple22);
        List terms = allLeft.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Real x = (Real)tuple2._1();
            Constant a = (Constant)tuple2._2();
            List list = allRight.map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Real y = (Real)tuple2._1();
                Constant c = (Constant)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)x.$times(y), (Object)a.$times(c));
                return tuple22;
            });
            return list;
        });
        Tuple2 tuple23 = (Tuple2)terms.foldLeft((Object)new Tuple2((Object)Coefficients$.MODULE$.Empty(), (Object)Constant$.MODULE$.Zero()), (Function2 & Serializable)(x0$3, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Coefficients nAx = (Coefficients)tuple22._1();
                    Constant nB = (Constant)tuple22._2();
                    if (tuple23 != null) {
                        Real x = (Real)tuple23._1();
                        Constant a = (Constant)tuple23._2();
                        if (x instanceof NonConstant) {
                            NonConstant nonConstant = (NonConstant)x;
                            return new Tuple2((Object)nAx.merge(Coefficients$.MODULE$.apply((Tuple2<NonConstant, Constant>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonConstant), (Object)a))), (Object)nB);
                        }
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple24 = (Tuple2)tuple2._1();
            Tuple2 tuple25 = (Tuple2)tuple2._2();
            if (tuple24 == null) throw new MatchError((Object)tuple2);
            Coefficients nAx = (Coefficients)tuple24._1();
            Constant nB = (Constant)tuple24._2();
            if (tuple25 == null) throw new MatchError((Object)tuple2);
            Real c = (Real)tuple25._1();
            Constant a = (Constant)tuple25._2();
            if (!(c instanceof Constant)) throw new MatchError((Object)tuple2);
            Constant constant = (Constant)c;
            return new Tuple2((Object)nAx, (Object)nB.$plus(constant.$times(a)));
        });
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Coefficients newAx = (Coefficients)tuple23._1();
        Constant newB = (Constant)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)newAx, (Object)newB);
        Tuple2 tuple25 = tuple24;
        Coefficients newAx2 = (Coefficients)tuple25._1();
        Constant newB2 = (Constant)tuple25._2();
        return Line$.MODULE$.apply(newAx2, newB2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Real> log(Line line) {
        Coefficients coefficients = line.ax();
        if (!(coefficients instanceof Coefficients.One)) return None$.MODULE$;
        Coefficients.One one = (Coefficients.One)coefficients;
        NonConstant x = one.term();
        Constant a = one.coefficient();
        if (!a.isPositive()) return None$.MODULE$;
        if (!line.b().isZero()) return None$.MODULE$;
        return new Some((Object)x.log().$plus(a.log()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Real> pow(Line line, Constant exponent) {
        Coefficients coefficients = line.ax();
        if (!(coefficients instanceof Coefficients.One)) return None$.MODULE$;
        Coefficients.One one = (Coefficients.One)coefficients;
        NonConstant x = one.term();
        Constant a = one.coefficient();
        if (!line.b().isZero()) return None$.MODULE$;
        return new Some((Object)x.pow(exponent).$times(RealOps$.MODULE$.pow((Real)a, exponent)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Real simplify(Coefficients ax, Constant b) {
        void var3_8;
        Coefficients coefficients = ax;
        Coefficients coefficients2 = Coefficients$.MODULE$.Empty();
        Coefficients coefficients3 = coefficients;
        if (!(coefficients2 != null ? !coefficients2.equals(coefficients3) : coefficients3 != null)) {
            Constant constant = b;
            return var3_8;
        }
        if (coefficients instanceof Coefficients.One) {
            Coefficients.One one = (Coefficients.One)coefficients;
            NonConstant x = one.term();
            Constant a = one.coefficient();
            if (a.isOne() && b.isZero()) {
                NonConstant nonConstant = x;
                return var3_8;
            }
        }
        Line line = Line$.MODULE$.apply(ax, b);
        return var3_8;
    }

    private LineOps$() {
    }
}

