/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.compute;

import com.stripe.rainier.compute.Coefficients;
import com.stripe.rainier.compute.Coefficients$;
import com.stripe.rainier.compute.Constant;
import com.stripe.rainier.compute.Constant$;
import com.stripe.rainier.compute.Line;
import com.stripe.rainier.compute.LineOps$;
import com.stripe.rainier.compute.LogLine;
import com.stripe.rainier.compute.LogLine$;
import com.stripe.rainier.compute.NonConstant;
import com.stripe.rainier.compute.Real;
import com.stripe.rainier.compute.Real$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.RichInt$;

public final class LogLineOps$ {
    public static final LogLineOps$ MODULE$ = new LogLineOps$();
    private static final int DistributeToMaxTerms = 20;

    public Real multiply(LogLine left, LogLine right) {
        Coefficients merged = left.ax().merge(right.ax());
        return merged.isEmpty() ? Real$.MODULE$.one() : new LogLine(merged);
    }

    public LogLine pow(LogLine line, Constant v) {
        return new LogLine(line.ax().mapCoefficients((Function1<Constant, Constant>)(Function1 & Serializable)x$1 -> x$1.$times(v)));
    }

    public Option<Real> log(LogLine line) {
        return None$.MODULE$;
    }

    public int DistributeToMaxTerms() {
        return DistributeToMaxTerms;
    }

    public Option<Tuple2<Coefficients, Constant>> distribute(LogLine line) {
        Tuple2 initial = new Tuple2((Object)package$.MODULE$.List().empty(), (Object)Option$.MODULE$.empty());
        Tuple2 tuple2 = (Tuple2)line.ax().toList().foldLeft((Object)initial, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    List f = (List)tuple22._1();
                    Option option = (Option)tuple22._2();
                    if (None$.MODULE$.equals(option) && tuple23 != null) {
                        NonConstant l = (NonConstant)tuple23._1();
                        Constant c = (Constant)tuple23._2();
                        if (l instanceof Line) {
                            Line line = (Line)l;
                            if (c.isOne() && LogLineOps$.nTerms$1(line) < MODULE$.DistributeToMaxTerms()) {
                                return new Tuple2((Object)f, (Object)new Some((Object)line));
                            }
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Tuple2 tuple24 = (Tuple2)tuple2._1();
                Tuple2 tuple25 = (Tuple2)tuple2._2();
                if (tuple24 != null) {
                    List f = (List)tuple24._1();
                    Option option = (Option)tuple24._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Line t = (Line)some.value();
                        if (tuple25 != null) {
                            NonConstant l = (NonConstant)tuple25._1();
                            Constant c = (Constant)tuple25._2();
                            if (l instanceof Line) {
                                Line line = (Line)l;
                                if (c.isOne() && LogLineOps$.nTerms$1(t) * LogLineOps$.nTerms$1(line) < MODULE$.DistributeToMaxTerms()) {
                                    return new Tuple2((Object)f, (Object)new Some((Object)LineOps$.MODULE$.multiply(t, line)));
                                }
                            }
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Tuple2 tuple26 = (Tuple2)tuple2._1();
                Tuple2 tuple27 = (Tuple2)tuple2._2();
                if (tuple26 != null) {
                    List f = (List)tuple26._1();
                    Option option = (Option)tuple26._2();
                    if (None$.MODULE$.equals(option) && tuple27 != null) {
                        NonConstant l = (NonConstant)tuple27._1();
                        Constant c = (Constant)tuple27._2();
                        if (l instanceof Line) {
                            Line line = (Line)l;
                            if (c.isTwo() && LogLineOps$.nTerms2$1(line) < MODULE$.DistributeToMaxTerms()) {
                                return new Tuple2((Object)f, (Object)new Some((Object)LineOps$.MODULE$.multiply(line, line)));
                            }
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Tuple2 tuple28 = (Tuple2)tuple2._1();
                Tuple2 tuple29 = (Tuple2)tuple2._2();
                if (tuple28 != null) {
                    List f = (List)tuple28._1();
                    Option option = (Option)tuple28._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Line t = (Line)some.value();
                        if (tuple29 != null) {
                            NonConstant l = (NonConstant)tuple29._1();
                            Constant c = (Constant)tuple29._2();
                            if (l instanceof Line) {
                                Line line = (Line)l;
                                if (c.isTwo() && LogLineOps$.nTerms$1(t) * LogLineOps$.nTerms2$1(line) < MODULE$.DistributeToMaxTerms()) {
                                    return new Tuple2((Object)f, (Object)new Some((Object)LineOps$.MODULE$.multiply(t, LineOps$.MODULE$.multiply(line, line))));
                                }
                            }
                        }
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Tuple2 tuple210 = (Tuple2)tuple2._1();
            Tuple2 xa = (Tuple2)tuple2._2();
            if (tuple210 == null) throw new MatchError((Object)tuple2);
            List f = (List)tuple210._1();
            Option opt = (Option)tuple210._2();
            Tuple2 tuple211 = xa;
            return new Tuple2((Object)f.$colon$colon((Object)tuple211), (Object)opt);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List factors = (List)tuple2._1();
        Option terms = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)factors, (Object)terms);
        Tuple2 tuple23 = tuple22;
        List factors2 = (List)tuple23._1();
        Option terms2 = (Option)tuple23._2();
        return terms2.map((Function1 & Serializable)l -> {
            Tuple2 tuple2;
            if (factors2.isEmpty()) {
                tuple2 = new Tuple2((Object)l.ax(), (Object)l.b());
            } else {
                LogLine ll = new LogLine(Coefficients$.MODULE$.apply((Seq<Tuple2<NonConstant, Constant>>)factors2));
                Tuple2 tuple22 = (Tuple2)l.ax().toList().foldLeft((Object)new Tuple2((Object)Coefficients$.MODULE$.apply((Tuple2<NonConstant, Constant>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ll), (Object)l.b())), (Object)Constant$.MODULE$.Zero()), (Function2 & Serializable)(x0$2, x1$2) -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = new Tuple2(x0$2, x1$2);
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    Tuple2 tuple24 = (Tuple2)tuple22._2();
                    if (tuple23 == null) throw new MatchError((Object)tuple22);
                    Coefficients nAx = (Coefficients)tuple23._1();
                    Constant nB = (Constant)tuple23._2();
                    if (tuple24 == null) throw new MatchError((Object)tuple22);
                    NonConstant x = (NonConstant)tuple24._1();
                    Constant a = (Constant)tuple24._2();
                    Real real = MODULE$.multiply(ll, LogLine$.MODULE$.apply(x));
                    if (real instanceof Constant) {
                        Constant constant = (Constant)real;
                        tuple2 = new Tuple2((Object)nAx, (Object)nB.$plus(constant.$times(a)));
                        return tuple2;
                    } else {
                        if (!(real instanceof NonConstant)) throw new MatchError((Object)real);
                        NonConstant nonConstant = (NonConstant)real;
                        tuple2 = new Tuple2((Object)nAx.merge(Coefficients$.MODULE$.apply((Tuple2<NonConstant, Constant>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonConstant), (Object)a))), (Object)nB);
                    }
                    return tuple2;
                });
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                Coefficients newAx = (Coefficients)tuple22._1();
                Constant newB = (Constant)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)newAx, (Object)newB);
                Tuple2 tuple24 = tuple23;
                Coefficients newAx2 = (Coefficients)tuple24._1();
                Constant newB2 = (Constant)tuple24._2();
                tuple2 = new Tuple2((Object)newAx2, (Object)newB2);
            }
            return tuple2;
        });
    }

    private int gcd(int x, int y) {
        while (y != 0) {
            int n = y;
            y = x % y;
            x = n;
        }
        return RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(x));
    }

    private static final int nTerms$1(Line l) {
        return l.b().isZero() ? l.ax().size() : l.ax().size() + 1;
    }

    private static final int nTerms2$1(Line l) {
        int n = LogLineOps$.nTerms$1(l);
        return n * (n + 1) / 2;
    }

    private LogLineOps$() {
    }
}

