/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.compute;

import com.stripe.rainier.compute.Column;
import com.stripe.rainier.compute.Constant$;
import com.stripe.rainier.compute.Lookup$;
import com.stripe.rainier.compute.Parameter;
import com.stripe.rainier.compute.Prior;
import com.stripe.rainier.compute.Real;
import com.stripe.rainier.compute.RealOps$;
import com.stripe.rainier.compute.ToReal;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Real$ {
    public static final Real$ MODULE$ = new Real$();
    private static final Real zero = Constant$.MODULE$.Zero();
    private static final Real one = Constant$.MODULE$.One();
    private static final Real two = Constant$.MODULE$.Two();
    private static final Real negOne = Constant$.MODULE$.NegOne();
    private static final Real Pi = Constant$.MODULE$.Pi();
    private static final Real infinity = Constant$.MODULE$.Infinity();
    private static final Real negInfinity = Constant$.MODULE$.NegInfinity();

    public <N> Real apply(N value, ToReal<N> toReal) {
        return toReal.apply(value);
    }

    public <A> Seq<Real> seq(Seq<A> as, ToReal<A> toReal) {
        return (Seq)as.map((Function1 & Serializable)x$1 -> toReal.apply(x$1));
    }

    public Real sum(Iterable<Real> seq) {
        return (Real)seq.foldLeft((Object)this.zero(), (Function2 & Serializable)(x$2, x$3) -> x$2.$plus((Real)x$3));
    }

    public Real logSumExp(Iterable<Real> seq) {
        Real max = (Real)seq.reduce((Function2 & Serializable)(x$4, x$5) -> x$4.max((Real)x$5));
        Iterable shifted = (Iterable)seq.map((Function1 & Serializable)x -> x.$minus(max));
        Real summed = this.sum((Iterable<Real>)((Iterable)shifted.map((Function1 & Serializable)x$6 -> x$6.exp())));
        return summed.log().$plus(max);
    }

    public Parameter parameter() {
        return new Parameter(new Prior(this.zero()));
    }

    /*
     * WARNING - void declaration
     */
    public Parameter parameter(Function1<Parameter, Real> fn) {
        void var2_2;
        Parameter x = this.parameter();
        x.prior_$eq(new Prior((Real)fn.apply((Object)x)));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Vector<Parameter> parameters(int size, Function1<Vector<Parameter>, Real> fn) {
        void var3_3;
        Vector vector = (Vector)package$.MODULE$.Vector().fill(size, (Function0 & Serializable)() -> MODULE$.parameter());
        Prior prior = new Prior((Real)fn.apply((Object)vector));
        vector.toList().foreach((Function1 & Serializable)x -> {
            x.prior_$eq(prior);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public Real doubles(Seq<Object> seq) {
        return new Column((double[])seq.toArray((ClassTag)ClassTag$.MODULE$.Double()));
    }

    public Real longs(Seq<Object> seq) {
        return this.doubles((Seq<Object>)((Seq)seq.map((Function1)(JFunction1.mcDJ.sp & Serializable)x$7 -> x$7)));
    }

    public Real eq(Real left, Real right, Real ifTrue, Real ifFalse) {
        return this.lookupCompare(left, right, ifFalse, ifTrue, ifFalse);
    }

    public Real lt(Real left, Real right, Real ifTrue, Real ifFalse) {
        return this.lookupCompare(left, right, ifFalse, ifFalse, ifTrue);
    }

    public Real gt(Real left, Real right, Real ifTrue, Real ifFalse) {
        return this.lookupCompare(left, right, ifTrue, ifFalse, ifFalse);
    }

    public Real lte(Real left, Real right, Real ifTrue, Real ifFalse) {
        return this.lookupCompare(left, right, ifFalse, ifTrue, ifTrue);
    }

    public Real gte(Real left, Real right, Real ifTrue, Real ifFalse) {
        return this.lookupCompare(left, right, ifTrue, ifTrue, ifFalse);
    }

    private Real lookupCompare(Real left, Real right, Real gt, Real eq2, Real lt) {
        return Lookup$.MODULE$.apply(RealOps$.MODULE$.compare(left, right), (Seq<Real>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Real[]{lt, eq2, gt}))), -1);
    }

    public Real zero() {
        return zero;
    }

    public Real one() {
        return one;
    }

    public Real two() {
        return two;
    }

    public Real negOne() {
        return negOne;
    }

    public Real Pi() {
        return Pi;
    }

    public Real infinity() {
        return infinity;
    }

    public Real negInfinity() {
        return negInfinity;
    }

    private Real$() {
    }
}

