/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.rainier.ir;

import com.stripe.rainier.internal.asm.tree.MethodNode;
import com.stripe.rainier.ir.ClassGenerator$;
import com.stripe.rainier.ir.CompiledFunction;
import com.stripe.rainier.ir.Expr;
import com.stripe.rainier.ir.ExprClassGenerator;
import com.stripe.rainier.ir.ExprMethodGenerator;
import com.stripe.rainier.ir.GeneratedClassLoader;
import com.stripe.rainier.ir.Log$;
import com.stripe.rainier.ir.MethodDef;
import com.stripe.rainier.ir.MethodRef;
import com.stripe.rainier.ir.OutputClassGenerator;
import com.stripe.rainier.ir.Packer;
import com.stripe.rainier.ir.Param;
import com.stripe.rainier.ir.VarTypes;
import com.stripe.rainier.ir.VarTypes$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class CompiledFunction$ {
    public static final CompiledFunction$ MODULE$ = new CompiledFunction$();

    public CompiledFunction apply(Seq<Param> inputs, Seq<Tuple2<String, Expr>> exprs, int methodSizeLimit, int classSizeLimit) {
        Log$.MODULE$.FINE().log("Compiling %d inputs, %d outputs, methodSizeLimit %s, classSizeLimit %d", (Object)BoxesRunTime.boxToInteger((int)inputs.size()), (Object)BoxesRunTime.boxToInteger((int)exprs.size()), (Object)BoxesRunTime.boxToInteger((int)methodSizeLimit), (Object)BoxesRunTime.boxToInteger((int)classSizeLimit));
        String outputClassName = ClassGenerator$.MODULE$.freshName();
        Seq methodGroups = (Seq)exprs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            Expr expr = (Expr)tuple2._2();
            Packer packer = new Packer(methodSizeLimit);
            Log$.MODULE$.FINE().log("Packing expression for %s", (Object)name);
            MethodRef outputRef = packer.pack(expr);
            Log$.MODULE$.FINE().log("Packed %s into %d methods", (Object)name, packer.methods().size());
            Tuple3 tuple3 = new Tuple3((Object)new StringBuilder(1).append(outputClassName).append("$").append(name).toString(), (Object)outputRef, packer.methods());
            return tuple3;
        });
        Seq allMeths = (Seq)methodGroups.flatMap((Function1 & Serializable)x$1 -> (List)x$1._3());
        Log$.MODULE$.FINE().log("Scanning var types");
        VarTypes varTypes = VarTypes$.MODULE$.methods((Seq<MethodDef>)allMeths.toList());
        Log$.MODULE$.FINE().log("Found references for %d symbols", varTypes.numReferences().size());
        Log$.MODULE$.FINE().log("Generating method nodes");
        Seq methodNodes = (Seq)methodGroups.flatMap((Function1 & Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String classPrefix = (String)tuple3._1();
            List methods = (List)tuple3._3();
            List list = methods.map((Function1 & Serializable)meth -> {
                ExprMethodGenerator mg = new ExprMethodGenerator((MethodDef)meth, inputs, varTypes, classPrefix, classSizeLimit);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mg.className()), (Object)mg.methodNode());
            });
            return list;
        });
        int numInputs = inputs.size();
        int numGlobals = varTypes.globals().size();
        int numOutputs = methodGroups.size();
        Log$.MODULE$.FINE().log("Found %d locals and %d globals", varTypes.locals().size(), varTypes.globals().size());
        Seq outputIDs = (Seq)methodGroups.map((Function1 & Serializable)x0$3 -> {
            Tuple3 tuple3 = x0$3;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String classPrefix = (String)tuple3._1();
            MethodRef outputRef = (MethodRef)tuple3._2();
            Tuple2 tuple2 = new Tuple2((Object)classPrefix, (Object)BoxesRunTime.boxToInteger((int)outputRef.sym().id()));
            return tuple2;
        });
        OutputClassGenerator ocg = new OutputClassGenerator(outputClassName, classSizeLimit, (Seq<Tuple2<String, Object>>)outputIDs, numInputs, numGlobals, numOutputs);
        Log$.MODULE$.FINE().log("Generating class nodes");
        List ecgs = ((IterableOnceOps)methodNodes.groupBy((Function1 & Serializable)x$2 -> (String)x$2._1()).map((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String className = (String)tuple2._1();
            Seq nodes = (Seq)tuple2._2();
            ExprClassGenerator exprClassGenerator = new ExprClassGenerator(className, (Seq<MethodNode>)nodes.toList().map((Function1 & Serializable)x$3 -> (MethodNode)x$3._2()));
            return exprClassGenerator;
        })).toList();
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        GeneratedClassLoader classLoader = new GeneratedClassLoader(ocg, (Seq<ExprClassGenerator>)ecgs, parentClassLoader);
        int bytecodeSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)classLoader.bytecode().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(x$4))))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Log$.MODULE$.FINE().log("Creating new instance of %s, total bytecode size %d", (Object)outputClassName, bytecodeSize);
        return classLoader.newInstance();
    }

    public double output(CompiledFunction cf, double[] inputs, double[] globals, int index) {
        double d;
        int i = index % 10;
        int j = index / 10;
        int n = i;
        switch (n) {
            case 0: {
                d = cf.output0(inputs, globals, j);
                break;
            }
            case 1: {
                d = cf.output1(inputs, globals, j);
                break;
            }
            case 2: {
                d = cf.output2(inputs, globals, j);
                break;
            }
            case 3: {
                d = cf.output3(inputs, globals, j);
                break;
            }
            case 4: {
                d = cf.output4(inputs, globals, j);
                break;
            }
            case 5: {
                d = cf.output5(inputs, globals, j);
                break;
            }
            case 6: {
                d = cf.output6(inputs, globals, j);
                break;
            }
            case 7: {
                d = cf.output7(inputs, globals, j);
                break;
            }
            case 8: {
                d = cf.output8(inputs, globals, j);
                break;
            }
            case 9: {
                d = cf.output9(inputs, globals, j);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return d;
    }

    private CompiledFunction$() {
    }
}

