/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.codegen.models;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertiesModel {
    public AbstractPropertiesModel() {
    }

    public AbstractPropertiesModel(Properties props) {
    }

    public Properties toProperties() {
        Properties props = new Properties();
        return props;
    }

    public boolean getBoolean(Properties props, String key, boolean defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public void putBoolean(Properties props, String key, Boolean value) {
        if (value != null) {
            props.put(key, value.toString());
        }
    }

    public long getLong(Properties props, String key, long defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public void putLong(Properties props, String key, Long value) {
        if (value != null) {
            props.put(key, value.toString());
        }
    }

    public int getInt(Properties props, String key, int defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public void putInt(Properties props, String key, Integer value) {
        if (value != null) {
            props.put(key, value.toString());
        }
    }

    public String getString(Properties props, String key, String defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void putString(Properties props, String key, String value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    public File getFile(Properties props, String key, File defaultValue) {
        String pathName = this.getString(props, key, null);
        if (pathName == null) {
            return defaultValue;
        }
        return new File(pathName);
    }

    public void putFile(Properties props, String key, File value) {
        if (value != null) {
            try {
                props.put(key, value.getCanonicalPath());
            }
            catch (IOException e) {
                props.put(key, e.getMessage());
            }
        }
    }

    public List<String> getStringList(Properties props, String key, List<String> defaultValue) {
        int i = 0;
        String value = this.getString(props, key + '_' + Integer.toString(i), null);
        if (value == null) {
            return defaultValue;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (value != null) {
            list.add(value);
            value = this.getString(props, key + '_' + Integer.toString(++i), null);
        }
        return list;
    }

    public void putStringList(Properties props, String key, List<String> value) {
        if (value != null) {
            int i = 0;
            for (String s : value) {
                this.putString(props, key + '_' + Integer.toString(i), s);
                ++i;
            }
        }
    }

    public URI getURI(Properties props, String key, URI defaultValue) {
        String value = this.getString(props, key, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public void putURI(Properties props, String key, URI value) {
        if (value != null) {
            this.putString(props, key, value.toString());
        }
    }

    public String toString() {
        return this.toProperties().toString();
    }
}

