/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.jaxb.gen;

import com.legstar.codegen.CodeGenMakeException;
import com.legstar.codegen.tasks.CommonsLoggingListener;
import com.legstar.jaxb.gen.CobolJAXBCustomizer;
import com.legstar.jaxb.gen.JaxbGenModel;
import com.sun.tools.xjc.XJC2Task;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;

public class CobolJAXBGenerator
extends Task {
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private File _xsdFile;
    private File _targetDir;
    private CobolJAXBCustomizer _customizer;
    private JaxbGenModel _context;

    public CobolJAXBGenerator() {
        this._context = new JaxbGenModel();
    }

    public CobolJAXBGenerator(JaxbGenModel context) {
        this._context = context;
    }

    public void init() {
        try {
            super.init();
            CommonsLoggingListener logger = new CommonsLoggingListener(this._log);
            this.getProject().addBuildListener((BuildListener)logger);
            this._customizer = new CobolJAXBCustomizer(this._context);
        }
        catch (ParserConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void execute() {
        this.log("JAXB generation started.");
        this.checkInput();
        XJC2Task xjcTask = new XJC2Task();
        xjcTask.setProject(this.getProject());
        xjcTask.setTaskName("xjcTask");
        File customizedXsdFile = this.getXsdFile();
        if (this._context.isInternalBindings()) {
            customizedXsdFile = this.createInternalCustomization(this.getXsdFile());
        } else {
            xjcTask.setBinding(this.createExternalCustomization(this.getXsdFile()));
        }
        xjcTask.setSchema(customizedXsdFile.getAbsolutePath());
        xjcTask.setPackage(this.getJaxbPackageName());
        xjcTask.setDestdir(this.getTargetDir());
        xjcTask.setExtension(true);
        xjcTask.setRemoveOldOutput(true);
        Commandline.Argument argLegStarPlugin = xjcTask.createArg();
        argLegStarPlugin.setValue("-Xlegstar-code");
        Commandline.Argument argNoValidation = xjcTask.createArg();
        argNoValidation.setValue("-nv");
        Commandline.Argument argNoHeader = xjcTask.createArg();
        argNoHeader.setValue("-no-header");
        if (this.isNoPackageInfo()) {
            Commandline.Argument argNoPackageInfo = xjcTask.createArg();
            argNoPackageInfo.setValue("-npa");
        }
        if (this.isEciCompatible()) {
            Commandline.Argument argEci = xjcTask.createArg();
            argEci.setValue("-eci");
        }
        xjcTask.execute();
        this.log("JAXB generation ended.");
    }

    protected void checkInput() {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"checkInput started");
                this._log.debug((Object)("Schema: " + this.getXsdFile()));
                this._log.debug((Object)("TargetDir: " + this.getTargetDir()));
                this._log.debug((Object)("Package name: " + this.getJaxbPackageName()));
                this._log.debug((Object)("xjbModel: " + (Object)((Object)this._context)));
            }
            if (this.getXsdFile() == null) {
                throw new BuildException("You must specify an XML schema file name");
            }
            if (this.getXsdFile().exists()) {
                if (this._log.isDebugEnabled()) {
                    for (String line : FileUtils.readLines((File)this.getXsdFile())) {
                        this._log.debug((Object)line);
                    }
                }
            } else {
                throw new BuildException("XML schema file " + this.getXsdFile().getAbsolutePath() + " does not exist");
            }
            if (this.getTargetDir() == null) {
                throw new BuildException("You must specify a destination directory");
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected File createInternalCustomization(File xsdFile) {
        try {
            File tempXsdFile = File.createTempFile("jaxb-schema", ".xsd");
            tempXsdFile.deleteOnExit();
            this._customizer.customize(xsdFile, tempXsdFile);
            return tempXsdFile;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public String createExternalCustomization(File xsdFile) {
        try {
            File tempXJBFile = File.createTempFile("jaxb-xjb", ".xml");
            tempXJBFile.deleteOnExit();
            URI xsdURILocation = xsdFile.toURI();
            this._context.setXsdLocation(xsdURILocation.toString());
            this._context.generateXjb(tempXJBFile);
            return tempXJBFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        catch (CodeGenMakeException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getXsdFile() {
        return this._xsdFile;
    }

    public void setXsdFile(File xsdFile) {
        this._xsdFile = xsdFile;
    }

    public String getJaxbPackageName() {
        return this._context.getJaxbPackageName();
    }

    public void setJaxbPackageName(String jaxbPackageName) {
        this._context.setJaxbPackageName(jaxbPackageName);
    }

    public File getTargetDir() {
        return this._targetDir;
    }

    public void setTargetDir(File targetDir) {
        this._targetDir = targetDir;
    }

    public boolean isGenerateIsSetMethod() {
        return this._context.isGenerateIsSetMethod();
    }

    public void setGenerateIsSetMethod(boolean generateIsSetMethod) {
        this._context.setGenerateIsSetMethod(generateIsSetMethod);
    }

    public long getSerializableUid() {
        return this._context.getSerializableUid();
    }

    public void setSerializableUid(long serializableUid) {
        this._context.setSerializableUid(serializableUid);
    }

    public String getTypeNamePrefix() {
        return this._context.getTypeNamePrefix();
    }

    public void setTypeNamePrefix(String typeNamePrefix) {
        this._context.setTypeNamePrefix(typeNamePrefix);
    }

    public String getTypeNameSuffix() {
        return this._context.getTypeNameSuffix();
    }

    public void setTypeNameSuffix(String typeNameSuffix) {
        this._context.setTypeNameSuffix(typeNameSuffix);
    }

    public String getElementNamePrefix() {
        return this._context.getElementNamePrefix();
    }

    public void setElementNamePrefix(String elementNamePrefix) {
        this._context.setElementNamePrefix(elementNamePrefix);
    }

    public String getElementNameSuffix() {
        return this._context.getElementNameSuffix();
    }

    public void setElementNameSuffix(String elementNameSuffix) {
        this._context.setElementNameSuffix(elementNameSuffix);
    }

    public boolean isInternalBindings() {
        return this._context.isInternalBindings();
    }

    public void setInternalBindings(boolean internalBindings) {
        this._context.setInternalBindings(internalBindings);
    }

    public boolean isEciCompatible() {
        return this._context.isEciCompatible();
    }

    public void setEciCompatible(boolean eciCompatible) {
        this._context.setEciCompatible(eciCompatible);
    }

    public boolean isNoPackageInfo() {
        return this._context.isNoPackageInfo();
    }

    public void setNoPackageInfo(boolean noPackageInfo) {
        this._context.setNoPackageInfo(noPackageInfo);
    }
}

