/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.jaxb.plugin;

import com.legstar.coxb.CobolComplexType;
import com.legstar.coxb.CobolElement;
import com.legstar.coxb.CobolType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElement;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.bind.api.impl.NameConverter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlSchemaType;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CobolJAXBAnnotator
extends Plugin {
    public static final String OPTION_NAME = "Xlegstar-code";
    private boolean isEciCompatible;
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String OPTION_USAGE = "  -Xlegstar-code      :  inject cobol binding annotation into the generated code";
    private static final List<String> WINDOWS_RESERVED_FILE_NAMES = Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9");
    private static final String RESERVED_FILE_NAME_SUFFIX = "w";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return OPTION_USAGE;
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList("http://www.legsem.com/legstar/xml/cobol-binding-1.0.1.xsd");
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return nsUri.equals("http://www.legsem.com/legstar/xml/cobol-binding-1.0.1.xsd") && (localName.equals("cobolElement") || localName.equals("value") || localName.equals("cobolComplexType"));
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        String arg = args[i];
        if (arg.equals("-Xlegstar-code")) {
            if (ArrayUtils.contains((Object[])args, (Object)"-eci")) {
                opt.setNameConverter((NameConverter)new EciCompatibleNameConverter(), (Plugin)this);
            } else {
                opt.setNameConverter((NameConverter)new WinCompatibleNameConverter(), (Plugin)this);
            }
        }
        if (arg.equals("-eci")) {
            this.isEciCompatible = true;
            return 1;
        }
        return 0;
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        if (this.isEciCompatible()) {
            for (Map.Entry entry : model.beans().entrySet()) {
                CClassInfo classInfo = (CClassInfo)entry.getValue();
                List properties = classInfo.getProperties();
                for (CPropertyInfo property : properties) {
                    String publicName = property.getName(true);
                    String newPrivateName = Character.toLowerCase(publicName.charAt(0)) + publicName.substring(1);
                    property.setName(false, newPrivateName);
                }
            }
        }
    }

    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) {
        long start = System.currentTimeMillis();
        for (CElementInfo eo : model.getModel().getAllElements()) {
            CPluginCustomization c;
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("CobolJAXBAnnotator::run::CElementInfo::" + eo.fullName()));
            }
            if ((c = eo.getCustomizations().find("http://www.legsem.com/legstar/xml/cobol-binding-1.0.1.xsd", "cobolElement")) == null) continue;
            c.markAsAcknowledged();
        }
        for (ClassOutline co : model.getClasses()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("CobolJAXBAnnotator::run::ClassOutline::" + co.implClass));
            }
            this.annotateClass(co);
            for (FieldOutline fo : co.getDeclaredFields()) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("CobolJAXBAnnotator::run::FieldOutline::" + fo.getPropertyInfo().getName(false)));
                }
                CPluginCustomization c = null;
                if (fo.getPropertyInfo() instanceof CReferencePropertyInfo) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)"FieldOutline is CReferencePropertyInfo");
                    }
                    for (CElement ce : ((CReferencePropertyInfo)fo.getPropertyInfo()).getElements()) {
                        c = ce.getCustomizations().find("http://www.legsem.com/legstar/xml/cobol-binding-1.0.1.xsd", "cobolElement");
                    }
                } else {
                    c = fo.getPropertyInfo().getCustomizations().find("http://www.legsem.com/legstar/xml/cobol-binding-1.0.1.xsd", "cobolElement");
                }
                if (c == null) continue;
                if (this._log.isDebugEnabled()) {
                    String javaType = fo.getRawType().name();
                    this._log.debug((Object)("CobolJAXBAnnotator::run::ClassOutline::" + c.element.getLocalName() + " type=" + javaType));
                }
                c.markAsAcknowledged();
                JDefinedClass coClass = co.implClass;
                JFieldVar jf = (JFieldVar)coClass.fields().get(fo.getPropertyInfo().getName(false));
                JAnnotationUse ce = jf.annotate(CobolElement.class);
                this.mapAnnotations(c, ce);
                this.setDefaultValue(jf, c.element);
                if (fo.getRawType().name().compareTo("byte[]") != 0) continue;
                JAnnotationUse xmlSchemaType = jf.annotate(XmlSchemaType.class);
                xmlSchemaType.param("name", "hexBinary");
            }
        }
        long end = System.currentTimeMillis();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Cobol annotation success.");
            this._log.debug((Object)("Duration=" + (end - start) + " ms"));
        }
        return true;
    }

    protected void setDefaultValue(JFieldVar jf, Element e) {
        if (!e.hasAttribute("value")) {
            return;
        }
        String value = e.getAttribute("value").trim();
        String type = jf.type().binaryName();
        if (type.equals("java.lang.String")) {
            jf.init(JExpr.lit((String)value));
        } else {
            if (value.length() == 0) {
                return;
            }
            if (value.startsWith("+")) {
                value = value.substring(1);
            }
            if (type.equals("java.math.BigDecimal")) {
                jf.init(JExpr.direct((String)("new BigDecimal(\"" + value + "\")")));
            } else if (type.equals("java.math.BigInteger")) {
                jf.init(JExpr.direct((String)("new BigInteger(\"" + value + "\")")));
            } else if (type.equals("short")) {
                jf.init(JExpr.lit((int)Short.parseShort(value)));
            } else if (type.equals("int")) {
                jf.init(JExpr.lit((int)Integer.parseInt(value)));
            } else if (type.equals("long")) {
                jf.init(JExpr.lit((long)Long.parseLong(value)));
            } else if (type.equals("float")) {
                jf.init(JExpr.lit((float)Float.parseFloat(value)));
            } else if (type.equals("double")) {
                jf.init(JExpr.lit((double)Double.parseDouble(value)));
            }
        }
    }

    protected void annotateClass(ClassOutline co) {
        CPluginCustomization c = co.target.getCustomizations().find("http://www.legsem.com/legstar/xml/cobol-binding-1.0.1.xsd", "cobolComplexType");
        if (c == null) {
            return;
        }
        c.markAsAcknowledged();
        JAnnotationUse ce = co.implClass.annotate(CobolComplexType.class);
        ce.param("javaClassName", c.element.getAttribute("javaClassName"));
    }

    protected void mapAnnotations(CPluginCustomization c, JAnnotationUse ce) {
        ce.param("cobolName", c.element.getAttribute("cobolName"));
        String cobolType = c.element.getAttribute("type");
        ce.param("type", (Enum)CobolType.valueOf((String)cobolType));
        this.setNumericParm(c.element, "levelNumber", ce);
        this.setBooleanParm(c.element, "justifiedRight", ce);
        this.setBooleanParm(c.element, "signed", ce);
        this.setBooleanParm(c.element, "signLeading", ce);
        this.setBooleanParm(c.element, "signSeparate", ce);
        this.setNumericParm(c.element, "totalDigits", ce);
        this.setNumericParm(c.element, "fractionDigits", ce);
        this.setNumericParm(c.element, "minOccurs", ce);
        this.setNumericParm(c.element, "maxOccurs", ce);
        this.setStringParm(c.element, "dependingOn", ce);
        this.setBooleanParm(c.element, "isODOObject", ce);
        this.setStringParm(c.element, "redefines", ce);
        this.setBooleanParm(c.element, "isRedefined", ce);
        this.setStringParm(c.element, "picture", ce);
        this.setStringParm(c.element, "usage", ce);
        this.setStringParm(c.element, "value", ce);
        this.setBooleanParm(c.element, "customVariable", ce);
        this.setStringParm(c.element, "marshalChoiceStrategyClassName", ce);
        this.setStringParm(c.element, "unmarshalChoiceStrategyClassName", ce);
        this.setNumericParm(c.element, "srceLine", ce);
    }

    protected void setBooleanParm(Element e, String xmlMarkup, JAnnotationUse ce) {
        String value;
        String cobolProperty = xmlMarkup;
        if (!cobolProperty.startsWith("is")) {
            cobolProperty = "is" + xmlMarkup.substring(0, 1).toUpperCase(Locale.getDefault()) + xmlMarkup.substring(1, xmlMarkup.length());
        }
        if ((value = e.getAttribute(xmlMarkup)) == null || value.length() == 0) {
            return;
        }
        ce.param(cobolProperty, Boolean.valueOf(value).booleanValue());
    }

    protected void setNumericParm(Element e, String xmlMarkup, JAnnotationUse ce) {
        String cobolProperty = xmlMarkup;
        String value = e.getAttribute(xmlMarkup);
        if (value == null || value.length() == 0) {
            return;
        }
        ce.param(cobolProperty, Integer.valueOf(value).intValue());
    }

    protected void setStringParm(Element e, String xmlMarkup, JAnnotationUse ce) {
        String cobolProperty = xmlMarkup;
        String value = e.getAttribute(xmlMarkup);
        if (value == null || value.length() == 0) {
            return;
        }
        ce.param(cobolProperty, value);
    }

    public boolean isEciCompatible() {
        return this.isEciCompatible;
    }

    protected class WinCompatibleNameConverter
    extends NameConverter.Standard {
        protected WinCompatibleNameConverter() {
        }

        public String toClassName(String s) {
            String className = super.toClassName(s);
            return WINDOWS_RESERVED_FILE_NAMES.contains(className.toUpperCase()) ? className + CobolJAXBAnnotator.RESERVED_FILE_NAME_SUFFIX : className;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EciCompatibleNameConverter
    extends WinCompatibleNameConverter {
        protected EciCompatibleNameConverter() {
        }

        protected boolean isPunct(char c) {
            return c == '.' || c == '-' || c == ';' || c == '\u00b7' || c == '\u0387' || c == '\u06dd' || c == '\u06de';
        }

        protected boolean isLetter(char c) {
            return super.isLetter(c) || c == '_';
        }

        protected int classify(char c0) {
            if (c0 == '_') {
                return 2;
            }
            return super.classify(c0);
        }

        protected String toMixedCaseName(List<String> ss, boolean startUpper) {
            StringBuilder sb = new StringBuilder();
            if (!ss.isEmpty()) {
                if (startUpper) {
                    sb.append(Character.toUpperCase(ss.get(0).charAt(0)));
                    sb.append(ss.get(0).substring(1));
                } else {
                    sb.append(ss.get(0).toLowerCase());
                }
                for (int i = 1; i < ss.size(); ++i) {
                    sb.append(ss.get(i));
                }
            }
            return sb.toString();
        }

        public String capitalize(String s) {
            return s;
        }
    }
}

