/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.messaging;

import com.legstar.messaging.HostEndpoint;

public class LegStarAddress {
    private String mHostUserID;
    private String mHostPassword;
    private String mEndPointName;
    private String mHostCharset;
    private boolean mHostTraceMode = false;

    public LegStarAddress(String endPointName) {
        this.mEndPointName = endPointName;
    }

    public LegStarAddress(HostEndpoint endpoint) {
        this.mEndPointName = endpoint.getName();
        this.mHostCharset = endpoint.getHostCharset();
        this.mHostUserID = endpoint.getHostUserID();
        this.mHostPassword = endpoint.getHostPassword();
        this.mHostTraceMode = endpoint.isHostTraceMode();
    }

    public LegStarAddress(LegStarAddress address, HostEndpoint endpoint) {
        this(endpoint);
        if (address != null) {
            if (address.getEndPointName() != null && address.getEndPointName().length() > 0) {
                this.mEndPointName = address.getEndPointName();
            }
            if (address.getHostCharset() != null && address.getHostCharset().length() > 0) {
                this.mHostCharset = address.getHostCharset();
            }
            if (address.getHostUserID() != null && address.getHostUserID().length() > 0) {
                this.mHostUserID = address.getHostUserID();
            }
            if (address.getHostPassword() != null && address.getHostPassword().length() > 0) {
                this.mHostPassword = address.getHostPassword();
            }
            if (address.isHostTraceMode()) {
                this.mHostTraceMode = true;
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass() != LegStarAddress.class) {
            return false;
        }
        String ojbEndPointName = ((LegStarAddress)obj).getEndPointName();
        if (ojbEndPointName != null && this.mEndPointName != null && !ojbEndPointName.equals(this.mEndPointName)) {
            return false;
        }
        String ojbHostCharset = ((LegStarAddress)obj).getHostCharset();
        if (ojbHostCharset != null && this.mHostCharset != null && !ojbHostCharset.equals(this.mHostCharset)) {
            return false;
        }
        String ojbHostUserID = ((LegStarAddress)obj).getHostUserID();
        return ojbHostUserID == null || this.mHostUserID == null || ojbHostUserID.equals(this.mHostUserID);
    }

    public int hashCode() {
        String hashString = "";
        if (this.mEndPointName != null) {
            hashString = hashString + this.mEndPointName;
        }
        if (this.mHostCharset != null) {
            hashString = hashString + this.mHostCharset;
        }
        if (this.mHostUserID != null) {
            hashString = hashString + this.mHostUserID;
        }
        return hashString.hashCode();
    }

    public String getEndPointName() {
        return this.mEndPointName;
    }

    public void setEndPointName(String endPointName) {
        this.mEndPointName = endPointName;
    }

    public String getHostUserID() {
        return this.mHostUserID;
    }

    public void setHostUserID(String hostUserID) {
        this.mHostUserID = hostUserID;
    }

    public String getHostPassword() {
        return this.mHostPassword;
    }

    public void setHostPassword(String password) {
        this.mHostPassword = password;
    }

    public String getHostCharset() {
        return this.mHostCharset;
    }

    public void setHostCharset(String hostCharset) {
        this.mHostCharset = hostCharset;
    }

    public boolean isHostTraceMode() {
        return this.mHostTraceMode;
    }

    public void setHostTraceMode(boolean hostTraceMode) {
        this.mHostTraceMode = hostTraceMode;
    }

    public String getReport() {
        String report = "Address=[hostEndpoint=" + this.mEndPointName + "," + "hostCharset" + "=" + this.mHostCharset + "," + "hostUserID" + "=" + this.mHostUserID + "," + "hostTraceMode" + "=" + this.mHostTraceMode + "]";
        return report;
    }

    public String toString() {
        return this.getReport();
    }
}

