/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.messaging;

import com.legstar.messaging.CommareaPart;
import com.legstar.messaging.HeaderPartException;
import com.legstar.messaging.HostMessageFormatException;
import com.legstar.messaging.LegStarHeaderPart;
import com.legstar.messaging.LegStarMessagePart;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegStarMessage
implements Serializable {
    private static final long serialVersionUID = -1107635334404959251L;
    private LegStarHeaderPart mHeaderPart;
    private List<LegStarMessagePart> mDataParts;

    public LegStarMessage() throws HeaderPartException {
        this.mHeaderPart = new LegStarHeaderPart();
        this.mDataParts = new ArrayList<LegStarMessagePart>();
    }

    public LegStarMessage(LegStarHeaderPart headerPart, List<LegStarMessagePart> dataParts) {
        this.mHeaderPart = headerPart;
        this.mDataParts = dataParts;
    }

    public InputStream sendToHost() throws HostMessageFormatException {
        return new ByteArrayInputStream(this.toByteArray());
    }

    public void recvFromHost(InputStream hostStream) throws HostMessageFormatException {
        this.getHeaderPart().fromStream(hostStream);
        for (int i = 0; i < this.getHeaderPart().getDataPartsNumber(); ++i) {
            LegStarMessagePart part = new LegStarMessagePart();
            part.fromStream(hostStream);
            this.getDataParts().add(part);
        }
    }

    public int getHostSize() {
        int size = this.mHeaderPart.getHostSize();
        for (LegStarMessagePart part : this.mDataParts) {
            size += part.getHostSize();
        }
        return size;
    }

    public byte[] toByteArray() throws HostMessageFormatException {
        byte[] payload = new byte[this.getHostSize()];
        int pos = 0;
        pos = this.getHeaderPart().toByteArray(payload, pos);
        for (LegStarMessagePart part : this.getDataParts()) {
            pos = part.toByteArray(payload, pos);
        }
        return payload;
    }

    public int fromByteArray(byte[] src, int srcPos) throws HostMessageFormatException {
        int pos = 0;
        pos = this.getHeaderPart().fromByteArray(src, pos);
        for (int i = 0; i < this.getHeaderPart().getDataPartsNumber(); ++i) {
            LegStarMessagePart part = new LegStarMessagePart();
            pos = part.fromByteArray(src, pos);
            this.getDataParts().add(part);
        }
        return pos;
    }

    public List<LegStarMessagePart> getDataParts() {
        return this.mDataParts;
    }

    public LegStarMessagePart lookupDataPart(String partID) {
        for (LegStarMessagePart part : this.getDataParts()) {
            if (!part.getPartID().equals(partID)) continue;
            return part;
        }
        return null;
    }

    public void addDataPart(LegStarMessagePart part) {
        this.mDataParts.add(part);
        this.mHeaderPart.setDataPartsNumber(this.mHeaderPart.getDataPartsNumber() + 1);
    }

    public void setDataParts(List<LegStarMessagePart> dataParts) {
        this.mDataParts = dataParts;
    }

    public LegStarHeaderPart getHeaderPart() {
        return this.mHeaderPart;
    }

    public void setHeaderPart(LegStarHeaderPart headerPart) {
        this.mHeaderPart = headerPart;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(this.getClass().getSimpleName());
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", headerPart=").append(this.mHeaderPart.toString());
        for (int i = 0; i < this.mHeaderPart.getDataPartsNumber(); ++i) {
            LegStarMessagePart part = this.mDataParts.get(i);
            sb.append(", messagePart=").append(part.toString());
        }
        sb.append("\"}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LegStarMessage)) {
            return false;
        }
        LegStarMessage msg = (LegStarMessage)obj;
        if (!msg.getHeaderPart().equals(this.getHeaderPart())) {
            return false;
        }
        if (msg.getDataParts().size() != this.getDataParts().size()) {
            return false;
        }
        for (LegStarMessagePart part : msg.getDataParts()) {
            boolean found = false;
            for (LegStarMessagePart myPart : this.getDataParts()) {
                if (!part.getPartID().equals(myPart.getPartID()) || !part.equals(myPart)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.getHeaderPart().hashCode();
        for (int i = 0; i < this.getDataParts().size(); ++i) {
            hash += this.getDataParts().get(i).hashCode();
        }
        return hash;
    }

    public static boolean isLegStarMessage(byte[] payload) throws UnsupportedEncodingException {
        return LegStarHeaderPart.isLegStarHeader(payload);
    }

    public static byte[] getContentFromHostBytes(byte[] requestBytes) throws HostMessageFormatException {
        try {
            LegStarMessage legStarMessage = new LegStarMessage();
            legStarMessage.fromByteArray(requestBytes, 0);
            if (legStarMessage.getDataParts().size() == 0) {
                return new byte[0];
            }
            if (legStarMessage.getDataParts().size() == 1) {
                return legStarMessage.getDataParts().get(0).getContent();
            }
            throw new HostMessageFormatException("Multi-part messages not supported");
        }
        catch (HeaderPartException e) {
            throw new HostMessageFormatException(e);
        }
    }

    public static byte[] getHostBytesFromContent(byte[] content) throws HostMessageFormatException {
        try {
            LegStarMessage replyMessage = new LegStarMessage();
            replyMessage.addDataPart(new CommareaPart(content));
            return replyMessage.toByteArray();
        }
        catch (HeaderPartException e) {
            throw new HostMessageFormatException(e);
        }
    }
}

