/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.avro.cob2avro;

import com.legstar.avro.cob2avro.Cob2AvroGenericConverter;
import com.legstar.base.converter.AbstractCob2ObjectConverter;
import com.legstar.base.converter.FromHostResult;
import com.legstar.base.visitor.Cob2ObjectValidator;
import java.io.File;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;

public class Cob2AvroSpecificConverter
extends AbstractCob2ObjectConverter<SpecificRecord> {
    private final int hostBytesLen;
    private final Schema schema;
    private final Cob2AvroGenericConverter converter;
    private SpecificRecord specificRecord;

    public FromHostResult<SpecificRecord> convert(byte[] hostData, int start, int length) {
        FromHostResult<GenericRecord> result = this.converter.convert(hostData, start, length);
        if (result.getValue() == null) {
            return null;
        }
        this.specificRecord = (SpecificRecord)SpecificData.get().deepCopy(((GenericRecord)result.getValue()).getSchema(), result.getValue());
        return new FromHostResult(result.getBytesProcessed(), (Object)this.specificRecord);
    }

    public boolean isValid(byte[] hostData) {
        return this.isValid(hostData, 0, hostData.length);
    }

    public boolean isValid(byte[] hostData, int start, int length) {
        Cob2ObjectValidator validator = new Cob2ObjectValidator(this.getCobolContext(), hostData, start, length, null);
        validator.visit(this.getCobolComplexType());
        return validator.isValid();
    }

    public SpecificRecord getSpecificRecord() {
        return this.specificRecord;
    }

    public int getHostBytesLen() {
        return this.hostBytesLen;
    }

    private Cob2AvroSpecificConverter(Builder builder) {
        super((AbstractCob2ObjectConverter.Builder)builder);
        this.schema = builder.schema;
        if (this.schema == null) {
            throw new IllegalArgumentException("You must provide a valid ouput Avro Schema");
        }
        this.converter = ((Cob2AvroGenericConverter.Builder)((Cob2AvroGenericConverter.Builder)new Cob2AvroGenericConverter.Builder().cobolContext(this.getCobolContext())).cobolComplexType(this.getCobolComplexType())).schema(this.schema).build();
        this.hostBytesLen = (int)this.getCobolComplexType().getMaxBytesLen();
    }

    public static class Builder
    extends AbstractCob2ObjectConverter.Builder<SpecificRecord, Builder> {
        private Schema schema;

        public Cob2AvroSpecificConverter build() {
            return new Cob2AvroSpecificConverter(this);
        }

        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder schemaFile(File schemaFile) {
            try {
                this.schema = new Schema.Parser().parse(schemaFile);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            return this;
        }

        protected Builder self() {
            return this;
        }
    }
}

