/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.avro.cob2avro.io;

import com.legstar.avro.cob2avro.Cob2AvroGenericConverter;
import com.legstar.base.context.CobolContext;
import com.legstar.base.converter.FromHostResult;
import com.legstar.base.finder.CobolTypeFinder;
import com.legstar.base.type.composite.CobolComplexType;
import com.legstar.base.visitor.FromCobolChoiceStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZosDatumReader<D>
implements Iterator<D>,
Iterable<D>,
Closeable {
    private static final int MAX_COBOL_RECORD_LEN = 0x7FFFFFF;
    private final byte[] hostBytes;
    private final InputStream inStream;
    private final Cob2AvroGenericConverter converter;
    private long available;
    private long bytesRead;
    private int bytesPrefetched;
    private int lastProcessed;
    private long bytesProcessed;
    private static Logger log = LoggerFactory.getLogger(AbstractZosDatumReader.class);

    public AbstractZosDatumReader(InputStream inStream, long length, CobolContext cobolContext, CobolComplexType cobolComplexType, FromCobolChoiceStrategy customChoiceStrategy, Schema schema) throws IOException {
        this.inStream = inStream;
        this.converter = ((Cob2AvroGenericConverter.Builder)((Cob2AvroGenericConverter.Builder)((Cob2AvroGenericConverter.Builder)new Cob2AvroGenericConverter.Builder().cobolContext(cobolContext)).cobolComplexType(cobolComplexType)).customChoiceStrategy(customChoiceStrategy)).schema(schema).build();
        long recordLen = cobolComplexType.getMaxBytesLen();
        if (recordLen > 0x7FFFFFFL) {
            log.warn("Record maximum length of " + cobolComplexType.getMaxBytesLen() + " exceeds the maximum " + 0x7FFFFFF);
            recordLen = 0x7FFFFFFL;
        }
        this.hostBytes = new byte[(int)recordLen + this.hostBytesPrefixLen()];
        this.available = length;
    }

    @Override
    public Iterator<D> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.available - this.bytesProcessed > 0L;
    }

    @Override
    public D next() {
        try {
            ReadRecordStatus status = this.readRecord(this.hostBytes, this.lastProcessed);
            this.bytesRead += (long)status.getBytesRead();
            int prefixLen = this.hostBytesPrefixLen();
            FromHostResult<GenericRecord> result = this.converter.convert(this.hostBytes, prefixLen, status.getRecordLen() == -1 ? this.hostBytes.length : status.getRecordLen() + prefixLen);
            this.lastProcessed = result.getBytesProcessed();
            this.bytesProcessed += (long)this.lastProcessed;
            Object specific = SpecificData.get().deepCopy(((GenericRecord)result.getValue()).getSchema(), result.getValue());
            if (log.isDebugEnabled()) {
                log.debug("Avro record=" + specific.toString());
            }
            return (D)specific;
        }
        catch (IOException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (null != this.inStream) {
            this.inStream.close();
        }
    }

    public void seekRecordStart(CobolTypeFinder recordMatcher) throws IOException {
        int signatureLen = recordMatcher.getSignatureLen();
        if (signatureLen > this.hostBytes.length) {
            throw new IllegalArgumentException("The record matcher signature length is longer that the total record length");
        }
        int bytesRead = this.readFully(this.hostBytes, 0, signatureLen);
        if (bytesRead < signatureLen) {
            throw new IOException("Not enough bytes left for a record signature");
        }
        while (!recordMatcher.match(this.hostBytes, 0, signatureLen)) {
            System.arraycopy(this.hostBytes, 1, this.hostBytes, 0, signatureLen - 1);
            bytesRead += this.readFully(this.hostBytes, signatureLen - 1, 1);
        }
        this.setBytesPrefetched(signatureLen);
        this.bytesRead += (long)bytesRead;
        this.bytesProcessed = this.bytesRead - (long)signatureLen;
    }

    public abstract ReadRecordStatus readRecord(byte[] var1, int var2) throws IOException;

    public abstract int hostBytesPrefixLen();

    public int readFully(byte[] b, int off, int len) throws IOException {
        IOUtils.readFully((InputStream)this.inStream, (byte[])b, (int)off, (int)len);
        return len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return IOUtils.read((InputStream)this.inStream, (byte[])b, (int)off, (int)len);
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public int getBytesPrefetched() {
        return this.bytesPrefetched;
    }

    public void setBytesPrefetched(int bytesPrefetched) {
        this.bytesPrefetched = bytesPrefetched;
    }

    public class ReadRecordStatus {
        private final int recordLen;
        private final int bytesRead;

        public int getRecordLen() {
            return this.recordLen;
        }

        public int getBytesRead() {
            return this.bytesRead;
        }

        public ReadRecordStatus(int bytesRead) {
            this.recordLen = -1;
            this.bytesRead = bytesRead;
        }

        public ReadRecordStatus(int recordLen, int bytesRead) {
            this.recordLen = recordLen;
            this.bytesRead = bytesRead;
        }
    }
}

