/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.avro.generator;

import com.legstar.avro.generator.Cob2AvroGeneratotException;
import com.legstar.avro.generator.CustomSpecificCompiler;
import com.legstar.avro.translator.Xsd2AvroTranslator;
import com.legstar.base.generator.Xsd2CobolTypesGenerator;
import com.legstar.base.utils.NamespaceUtils;
import com.legstar.cob2xsd.Cob2Xsd;
import com.legstar.cob2xsd.Cob2XsdConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cob2AvroGenerator {
    private static final String AVSC_FILE_EXTENSION = ".avsc";
    private static final String XSD_FILE_EXTENSION = ".xsd";
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final String XSD_TARGET_SUB_FOLDER = "xsd";
    private static final String JAVA_TARGET_SUB_FOLDER = "java";
    private static final String AVSC_TARGET_SUB_FOLDER = "avsc";
    private final Cob2Xsd cob2xsd;
    private final Xsd2CobolTypesGenerator xsd2CobolTypes;
    private final Xsd2AvroTranslator cob2AvroTranslator;
    private static Logger log = LoggerFactory.getLogger(Cob2AvroGenerator.class);

    public Cob2AvroGenerator(Properties configProps) {
        this.cob2xsd = new Cob2Xsd(new Cob2XsdConfig(configProps));
        this.cob2AvroTranslator = new Xsd2AvroTranslator();
        this.xsd2CobolTypes = new Xsd2CobolTypesGenerator();
    }

    public boolean generate(File cobolFile, String cobolFileEncoding, File targetFolder, String targetPackageName, String xsltFileName) {
        try {
            log.info("COBOL to Avro generation for: {}", (Object)cobolFile);
            InputStreamReader reader = cobolFileEncoding == null ? new InputStreamReader(new FileInputStream(cobolFile)) : new InputStreamReader((InputStream)new FileInputStream(cobolFile), cobolFileEncoding);
            String targetSchemaName = FilenameUtils.getBaseName((String)cobolFile.getName().toLowerCase());
            return this.generate(reader, targetFolder, targetPackageName, targetSchemaName, xsltFileName);
        }
        catch (UnsupportedEncodingException e) {
            throw new Cob2AvroGeneratotException(e);
        }
        catch (FileNotFoundException e) {
            throw new Cob2AvroGeneratotException(e);
        }
    }

    public boolean generate(Reader cobolReader, File targetFolder, String targetPackageName, String targetSchemaName, String xsltFileName) {
        try {
            String xmlSchemaSource = this.generateXmlSchema(cobolReader, NamespaceUtils.toNamespace((String)targetPackageName), targetSchemaName, xsltFileName);
            this.serializeToFile(targetFolder, XSD_TARGET_SUB_FOLDER, targetSchemaName, XSD_FILE_EXTENSION, xmlSchemaSource);
            Map<String, String> codeMap = this.generateConverterClasses(xmlSchemaSource, targetPackageName);
            String subFolder = targetPackageName == null ? "" : targetPackageName.replace(".", "/") + "/";
            for (Map.Entry<String, String> entry : codeMap.entrySet()) {
                this.serializeToFile(targetFolder, JAVA_TARGET_SUB_FOLDER, subFolder + entry.getKey(), JAVA_FILE_EXTENSION, entry.getValue());
            }
            String avroSchemaSource = this.generateAvroSchema(xmlSchemaSource, targetPackageName, targetSchemaName);
            File avroSchemaFile = this.serializeToFile(targetFolder, AVSC_TARGET_SUB_FOLDER, targetSchemaName, AVSC_FILE_EXTENSION, avroSchemaSource);
            this.avroCompile(avroSchemaSource, avroSchemaFile, new File(targetFolder, JAVA_TARGET_SUB_FOLDER));
            log.info("COBOL to Avro generation succeeded");
            return true;
        }
        catch (Exception e) {
            log.error("COBOL to Avro generation failed for: {}", (Object)targetSchemaName, (Object)e);
            return false;
        }
    }

    private String generateXmlSchema(Reader cobolReader, String targetNamespace, String targetXmlSchemaName, String xsltFileName) {
        log.debug("XML schema {} generation started", (Object)(targetXmlSchemaName + XSD_FILE_EXTENSION));
        String xmlSchemaSource = this.cob2xsd.translate(cobolReader, NamespaceUtils.toNamespace((String)targetNamespace), xsltFileName);
        if (log.isDebugEnabled()) {
            log.debug("Generated Cobol-annotated XML Schema: ");
            log.debug(xmlSchemaSource);
        }
        log.debug("XML schema {} generation ended", (Object)(targetXmlSchemaName + XSD_FILE_EXTENSION));
        return xmlSchemaSource;
    }

    private Map<String, String> generateConverterClasses(String xmlSchemaSource, String targetPackageName) {
        log.debug("Converter support classes generation started");
        Map codeMap = this.xsd2CobolTypes.generate((Reader)new StringReader(xmlSchemaSource), targetPackageName);
        if (log.isDebugEnabled()) {
            log.debug("Generated converter support classes: ");
            for (String code : codeMap.values()) {
                log.debug(code);
                log.debug("\n");
            }
        }
        log.debug("Converter support classes generation ended");
        return codeMap;
    }

    private File serializeToFile(File target, String targetSubFolder, String fileName, String extension, String source) throws IOException {
        File targetFolder = new File(target, targetSubFolder);
        File targetFile = new File(targetFolder, fileName + extension);
        FileUtils.writeStringToFile((File)targetFile, (String)source);
        return targetFile;
    }

    private String generateAvroSchema(String xmlSchemaSource, String targetPackageName, String targetAvroSchemaName) throws IOException {
        log.debug("Avro schema {} generation started", (Object)(targetAvroSchemaName + AVSC_FILE_EXTENSION));
        String avroSchemaSource = this.cob2AvroTranslator.translate((Reader)new StringReader(xmlSchemaSource), targetPackageName, targetAvroSchemaName);
        if (log.isDebugEnabled()) {
            log.debug("Generated Avro Schema: ");
            log.debug(avroSchemaSource);
        }
        log.debug("Avro schema {} generation ended", (Object)(targetAvroSchemaName + AVSC_FILE_EXTENSION));
        return avroSchemaSource;
    }

    private void avroCompile(String avroSchemaSource, File avroSchemaFile, File javaTargetFolder) throws IOException {
        log.debug("Avro compiler started for: {}", (Object)avroSchemaFile);
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(avroSchemaSource);
        CustomSpecificCompiler compiler = new CustomSpecificCompiler(schema);
        compiler.setStringType(GenericData.StringType.CharSequence);
        compiler.compileToDestination(avroSchemaFile, javaTargetFolder);
        log.debug("Avro compiler ended for: {}", (Object)avroSchemaFile);
    }
}

