/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.librato.metrics.LibratoReporter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DummyApp {
    private static final int WORKER_COUNT = 10;
    private static final BlockingQueue<File> JOBS = new LinkedBlockingQueue<File>();
    private static final ExecutorService POOL = Executors.newFixedThreadPool(10);
    private static final MetricRegistry REGISTRY = new MetricRegistry();
    private static final Counter QUEUE_DEPTH = REGISTRY.counter(MetricRegistry.name(DummyApp.class, (String[])new String[]{"queue-depth"}));
    private static final Histogram DIRECTORY_SIZE = REGISTRY.histogram(MetricRegistry.name(DummyApp.class, (String[])new String[]{"directory-size"}));

    public static void main(String[] args) throws Exception {
        String username = System.getProperty("librato.user", "");
        String token = System.getProperty("librato.token", "");
        LibratoReporter.enable(LibratoReporter.builder(REGISTRY, username, token, "testing").setExpansionConfig(LibratoReporter.MetricExpansionConfig.ALL), 10L, TimeUnit.SECONDS);
        System.err.println("Scanning all files on your hard drive...");
        JOBS.add(new File("/"));
        QUEUE_DEPTH.inc();
        for (int i = 0; i < 10; ++i) {
            POOL.submit(new Job());
        }
        POOL.awaitTermination(30L, TimeUnit.DAYS);
    }

    public static class Job
    implements Runnable {
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    File file = (File)JOBS.poll(1L, TimeUnit.MINUTES);
                    QUEUE_DEPTH.dec();
                    if (!file.isDirectory()) continue;
                    List<File> contents = new DirectoryLister(file).list();
                    DIRECTORY_SIZE.update(contents.size());
                    QUEUE_DEPTH.inc((long)contents.size());
                    JOBS.addAll(contents);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DirectoryLister {
        private final MetricRegistry registry = new MetricRegistry();
        private final Counter counter = this.registry.counter(MetricRegistry.name(this.getClass(), (String[])new String[]{"directories"}));
        private final Meter meter = this.registry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"files"}));
        private final Timer timer = this.registry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"directory-listing"}));
        private final File directory;

        public DirectoryLister(File directory) {
            this.directory = directory;
        }

        public List<File> list() throws Exception {
            this.counter.inc();
            File[] list = (File[])this.timer.time((Callable)new Callable<File[]>(){

                @Override
                public File[] call() throws Exception {
                    return DirectoryLister.this.directory.listFiles();
                }
            });
            this.counter.dec();
            if (list == null) {
                return Collections.emptyList();
            }
            ArrayList<File> result = new ArrayList<File>(list.length);
            for (File file : list) {
                this.meter.mark();
                result.add(file);
            }
            return result;
        }
    }
}

