/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.librato.metrics.DeltaTracker;
import com.librato.metrics.HttpPoster;
import com.librato.metrics.MetricsLibratoBatch;
import com.librato.metrics.NingHttpPoster;
import com.librato.metrics.Sanitizer;
import com.ning.http.client.AsyncHttpClientConfig;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibratoReporter
extends ScheduledReporter
implements MetricsLibratoBatch.RateConverter,
MetricsLibratoBatch.DurationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(LibratoReporter.class);
    private final DeltaTracker deltaTracker;
    private final String source;
    private final long timeout;
    private final TimeUnit timeoutUnit;
    private final Sanitizer sanitizer;
    private final HttpPoster httpPoster;
    private final String prefix;
    private final String prefixDelimiter;
    private final Pattern sourceRegex;
    private final boolean deleteIdleStats;
    private final boolean omitComplexGauges;
    protected final MetricRegistry registry;
    protected final Clock clock;
    protected final MetricExpansionConfig expansionConfig;

    private LibratoReporter(MetricRegistry registry, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Sanitizer customSanitizer, String source, long timeout, TimeUnit timeoutUnit, Clock clock, MetricExpansionConfig expansionConfig, HttpPoster httpPoster, String prefix, String prefixDelimiter, Pattern sourceRegex, boolean deleteIdleStats, boolean omitComplexGauges) {
        super(registry, name, filter, rateUnit, durationUnit);
        this.registry = registry;
        this.sanitizer = customSanitizer;
        this.source = source;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        this.clock = clock;
        this.expansionConfig = expansionConfig;
        this.httpPoster = httpPoster;
        this.prefix = prefix;
        this.prefixDelimiter = prefixDelimiter;
        this.sourceRegex = sourceRegex;
        this.deltaTracker = new DeltaTracker(new DeltaMetricSupplier(registry));
        this.deleteIdleStats = deleteIdleStats;
        this.omitComplexGauges = omitComplexGauges;
    }

    @Override
    public double convertMetricDuration(double duration) {
        return this.convertDuration(duration);
    }

    @Override
    public double convertMetricRate(double rate) {
        return this.convertRate(rate);
    }

    public void start(long period, TimeUnit unit) {
        LOG.debug("Reporter starting at fixed rate of every {} {}", (Object)period, (Object)unit);
        super.start(period, unit);
    }

    public void report() {
        try {
            super.report();
        }
        catch (Exception exception) {
            LOG.error("Error sending report to librato", (Throwable)exception);
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        String name;
        long epoch = TimeUnit.MILLISECONDS.toSeconds(this.clock.getTime());
        MetricsLibratoBatch batch = new MetricsLibratoBatch(500, this.sanitizer, this.timeout, this.timeoutUnit, this.expansionConfig, this.httpPoster, this.prefix, this.prefixDelimiter, this.deltaTracker, this, this, this.sourceRegex, this.omitComplexGauges);
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            batch.addGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            batch.addCounter(entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            Histogram histogram;
            name = entry.getKey();
            if (this.skipMetric(name, (Counting)(histogram = (Histogram)entry.getValue()))) continue;
            batch.addHistogram(entry.getKey(), histogram);
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            Meter meter;
            name = entry.getKey();
            if (this.skipMetric(name, (Counting)(meter = (Meter)entry.getValue()))) continue;
            batch.addMeter(name, (Metered)meter);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            Timer timer;
            name = entry.getKey();
            if (this.skipMetric(name, (Counting)(timer = (Timer)entry.getValue()))) continue;
            batch.addTimer(name, timer);
        }
        batch.post(this.source, epoch);
    }

    private boolean skipMetric(String name, Counting counting) {
        return this.deleteIdleStats() && this.deltaTracker.peekDelta(name, counting.getCount()) == 0L;
    }

    private boolean deleteIdleStats() {
        return this.deleteIdleStats;
    }

    public static Builder builder(MetricRegistry metricRegistry, String username, String token, String source) {
        return new Builder(metricRegistry, username, token, source);
    }

    public static void enable(Builder builder, long interval, TimeUnit unit) {
        builder.build().start(interval, unit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetricExpansionConfig {
        public static MetricExpansionConfig ALL = new MetricExpansionConfig(EnumSet.allOf(ExpandedMetric.class));
        private final Set<ExpandedMetric> enabled;

        public MetricExpansionConfig(Set<ExpandedMetric> enabled) {
            this.enabled = EnumSet.copyOf(enabled);
        }

        public boolean isSet(ExpandedMetric metric) {
            return this.enabled.contains((Object)metric);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpandedMetric {
        MEDIAN("median"),
        PCT_75("75th"),
        PCT_95("95th"),
        PCT_98("98th"),
        PCT_99("99th"),
        PCT_999("999th"),
        COUNT("count"),
        RATE_MEAN("meanRate"),
        RATE_1_MINUTE("1MinuteRate"),
        RATE_5_MINUTE("5MinuteRate"),
        RATE_15_MINUTE("15MinuteRate");

        private final String displayName;

        public String buildMetricName(String metric) {
            return metric + "." + this.displayName;
        }

        private ExpandedMetric(String displayName) {
            this.displayName = displayName;
        }
    }

    public static class Builder {
        private String username;
        private String token;
        private final String source;
        private Sanitizer sanitizer = Sanitizer.NO_OP;
        private long timeout = 5L;
        private TimeUnit timeoutUnit = TimeUnit.SECONDS;
        private TimeUnit rateUnit = TimeUnit.SECONDS;
        private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
        private String name = "librato-reporter";
        private final MetricRegistry registry;
        private MetricFilter filter = MetricFilter.ALL;
        private Clock clock = Clock.defaultClock();
        private MetricExpansionConfig expansionConfig = MetricExpansionConfig.ALL;
        private HttpPoster httpPoster;
        private String prefix;
        private String prefixDelimiter = ".";
        private Pattern sourceRegex;
        private AsyncHttpClientConfig httpClientConfig;
        private boolean deleteIdleStats = true;
        private boolean omitComplexGauges;

        public Builder(MetricRegistry registry, String username, String token, String source) {
            this.registry = registry;
            this.username = username;
            this.token = token;
            this.source = source;
        }

        public Builder setOmitComplexGauges(boolean omitComplexGauges) {
            this.omitComplexGauges = omitComplexGauges;
            return this;
        }

        public Builder setDeleteIdleStats(boolean deleteIdleStats) {
            this.deleteIdleStats = deleteIdleStats;
            return this;
        }

        public Builder setSourceRegex(Pattern sourceRegex) {
            this.sourceRegex = sourceRegex;
            return this;
        }

        public Builder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setTimeoutUnit(TimeUnit timeoutUnit) {
            this.timeoutUnit = timeoutUnit;
            return this;
        }

        public Builder setPrefixDelimiter(String prefixDelimiter) {
            this.prefixDelimiter = prefixDelimiter;
            return this;
        }

        public Builder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder setHttpPoster(HttpPoster poster) {
            this.httpPoster = poster;
            return this;
        }

        public Builder setRateUnit(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder setDurationUnit(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeoutUnit) {
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setSanitizer(Sanitizer sanitizer) {
            this.sanitizer = sanitizer;
            return this;
        }

        public Builder setFilter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder setExpansionConfig(MetricExpansionConfig expansionConfig) {
            this.expansionConfig = expansionConfig;
            return this;
        }

        public Builder setHttpClientConfig(AsyncHttpClientConfig httpClientConfig) {
            this.httpClientConfig = httpClientConfig;
            return this;
        }

        public LibratoReporter build() {
            this.constructHttpPoster();
            return new LibratoReporter(this.registry, this.name, this.filter, this.rateUnit, this.durationUnit, this.sanitizer, this.source, this.timeout, this.timeoutUnit, this.clock, this.expansionConfig, this.httpPoster, this.prefix, this.prefixDelimiter, this.sourceRegex, this.deleteIdleStats, this.omitComplexGauges);
        }

        private void constructHttpPoster() {
            if (this.httpPoster == null) {
                String url = "https://metrics-api.librato.com/v1/metrics";
                this.httpPoster = this.httpClientConfig == null ? NingHttpPoster.newPoster((String)this.username, (String)this.token, (String)url) : NingHttpPoster.newPoster((String)this.username, (String)this.token, (String)url, (AsyncHttpClientConfig)this.httpClientConfig);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DeltaMetricSupplier
    implements DeltaTracker.MetricSupplier {
        final MetricRegistry registry;

        DeltaMetricSupplier(MetricRegistry registry) {
            this.registry = registry;
        }

        @Override
        public Map<String, Metric> getMetrics() {
            HashMap<String, Metric> map = new HashMap<String, Metric>();
            for (Map.Entry entry : this.registry.getMetrics().entrySet()) {
                String name = (String)entry.getKey();
                map.put(name, (Metric)entry.getValue());
            }
            return map;
        }
    }
}

