/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.librato.metrics.BatchResult;
import com.librato.metrics.DeltaTracker;
import com.librato.metrics.HttpPoster;
import com.librato.metrics.LibratoBatch;
import com.librato.metrics.LibratoReporter;
import com.librato.metrics.Measurement;
import com.librato.metrics.MultiSampleGaugeMeasurement;
import com.librato.metrics.Preconditions;
import com.librato.metrics.Sanitizer;
import com.librato.metrics.SourceInformation;
import com.librato.metrics.Versions;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsLibratoBatch
extends LibratoBatch {
    private static final Logger log = LoggerFactory.getLogger(MetricsLibratoBatch.class);
    private final LibratoReporter.MetricExpansionConfig expansionConfig;
    private final String prefix;
    private final String prefixDelimiter;
    private final DeltaTracker deltaTracker;
    private final DurationConverter durationConverter;
    private final RateConverter rateConverter;
    private final Pattern sourceRegex;
    private final boolean omitComplexGauges;
    public static final String AGENT_IDENTIFIER;

    public MetricsLibratoBatch(int postBatchSize, Sanitizer sanitizer, long timeout, TimeUnit timeoutUnit, LibratoReporter.MetricExpansionConfig expansionConfig, HttpPoster httpPoster, String prefix, String prefixDelimiter, DeltaTracker deltaTracker, RateConverter rateConverter, DurationConverter durationConverter, Pattern sourceRegex, boolean omitComplexGauges) {
        super(postBatchSize, sanitizer, timeout, timeoutUnit, AGENT_IDENTIFIER, httpPoster);
        this.expansionConfig = (LibratoReporter.MetricExpansionConfig)Preconditions.checkNotNull((Object)expansionConfig);
        this.prefix = MetricsLibratoBatch.checkPrefix(prefix);
        this.prefixDelimiter = prefixDelimiter;
        this.deltaTracker = deltaTracker;
        this.rateConverter = rateConverter;
        this.durationConverter = durationConverter;
        this.sourceRegex = sourceRegex;
        this.omitComplexGauges = omitComplexGauges;
    }

    public BatchResult post(String source, long epoch) {
        log.debug("Posting measurements");
        return super.post(source, Long.valueOf(epoch));
    }

    public void addCounterMeasurement(String name, Long value) {
        SourceInformation info = SourceInformation.from(this.sourceRegex, name);
        super.addCounterMeasurement(info.source, this.addPrefix(info.name), value);
    }

    public void addGaugeMeasurement(String name, Number value) {
        if (!this.checkNumber(name, value)) {
            return;
        }
        SourceInformation info = SourceInformation.from(this.sourceRegex, name);
        super.addGaugeMeasurement(info.source, this.addPrefix(info.name), value);
    }

    public void addGauge(String name, Gauge gauge) {
        Object value = gauge.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            if (!this.checkNumber(name, number)) {
                return;
            }
            this.addGaugeMeasurement(name, number);
        }
    }

    public void addCounter(String name, Counter counter) {
        this.addGaugeMeasurement(name, counter.getCount());
    }

    public void addHistogram(String name, Histogram histogram) {
        Long countDelta = this.deltaTracker.getDelta(name, histogram.getCount());
        this.maybeAdd(LibratoReporter.ExpandedMetric.COUNT, name, countDelta);
        boolean convertDurations = false;
        this.addSampling(name, (Sampling)histogram, false);
    }

    public void addMeter(String name, Metered meter) {
        Long deltaCount = this.deltaTracker.getDelta(name, meter.getCount());
        this.maybeAdd(LibratoReporter.ExpandedMetric.COUNT, name, deltaCount);
        this.maybeAdd(LibratoReporter.ExpandedMetric.RATE_MEAN, name, this.convertRate(meter.getMeanRate()));
        this.maybeAdd(LibratoReporter.ExpandedMetric.RATE_1_MINUTE, name, this.convertRate(meter.getOneMinuteRate()));
        this.maybeAdd(LibratoReporter.ExpandedMetric.RATE_5_MINUTE, name, this.convertRate(meter.getFiveMinuteRate()));
        this.maybeAdd(LibratoReporter.ExpandedMetric.RATE_15_MINUTE, name, this.convertRate(meter.getFifteenMinuteRate()));
    }

    public void addTimer(String name, Timer timer) {
        this.addMeter(name, (Metered)timer);
        boolean convertDurations = true;
        this.addSampling(name, (Sampling)timer, true);
    }

    public void addSampling(String name, Sampling sampling, boolean convert) {
        Snapshot snapshot = sampling.getSnapshot();
        this.maybeAdd(LibratoReporter.ExpandedMetric.MEDIAN, name, this.convertDuration(snapshot.getMedian(), convert));
        this.maybeAdd(LibratoReporter.ExpandedMetric.PCT_75, name, this.convertDuration(snapshot.get75thPercentile(), convert));
        this.maybeAdd(LibratoReporter.ExpandedMetric.PCT_95, name, this.convertDuration(snapshot.get95thPercentile(), convert));
        this.maybeAdd(LibratoReporter.ExpandedMetric.PCT_98, name, this.convertDuration(snapshot.get98thPercentile(), convert));
        this.maybeAdd(LibratoReporter.ExpandedMetric.PCT_99, name, this.convertDuration(snapshot.get99thPercentile(), convert));
        this.maybeAdd(LibratoReporter.ExpandedMetric.PCT_999, name, this.convertDuration(snapshot.get999thPercentile(), convert));
        if (!this.omitComplexGauges) {
            double sum = (double)snapshot.size() * snapshot.getMean();
            long count = snapshot.size();
            if (count > 0L) {
                MultiSampleGaugeMeasurement measurement;
                SourceInformation info = SourceInformation.from(this.sourceRegex, name);
                try {
                    measurement = MultiSampleGaugeMeasurement.builder((String)this.addPrefix(info.name)).setSource(info.source).setCount(Long.valueOf(count)).setSum((Number)this.convertDuration(sum, convert)).setMax((Number)this.convertDuration(snapshot.getMax(), convert)).setMin((Number)this.convertDuration(snapshot.getMin(), convert)).build();
                }
                catch (IllegalArgumentException e) {
                    log.warn("Could not create gauge", (Throwable)e);
                    return;
                }
                this.addMeasurement((Measurement)measurement);
            }
        }
    }

    private void maybeAdd(LibratoReporter.ExpandedMetric metric, String name, Number reading) {
        if (this.expansionConfig.isSet(metric)) {
            String metricName = metric.buildMetricName(name);
            if (!this.checkNumber(name, reading)) {
                return;
            }
            this.addGaugeMeasurement(metricName, reading);
        }
    }

    private String addPrefix(String metricName) {
        if (this.prefix == null || this.prefix.length() == 0) {
            return metricName;
        }
        return this.prefix + this.prefixDelimiter + metricName;
    }

    private static String checkPrefix(String prefix) {
        if ("".equals(prefix)) {
            throw new IllegalArgumentException("Prefix may either be null or a non-empty string");
        }
        return prefix;
    }

    boolean checkNumber(String name, Number value) {
        if (!this.isANumber(value)) {
            log.debug("Cannot add number {} for {}", (Object)value, (Object)name);
            return false;
        }
        return true;
    }

    private boolean isANumber(Number number) {
        double doubleValue = number.doubleValue();
        return !Double.isNaN(doubleValue) && !Double.isInfinite(doubleValue);
    }

    private double convertRate(double rate) {
        return this.rateConverter.convertMetricRate(rate);
    }

    private double convertDuration(double duration, boolean convert) {
        return convert ? this.convertDuration(duration) : duration;
    }

    private double convertDuration(double duration) {
        return this.durationConverter.convertMetricDuration(duration);
    }

    static {
        String metricsCoreVersion = Versions.getVersion((String)"META-INF/maven/io.dropwizard.metrics/metrics-core/pom.properties", Metric.class);
        String metricsLibratoVersion = Versions.getVersion((String)"META-INF/maven/com.librato.metrics/metrics-librato/pom.properties", LibratoReporter.class);
        AGENT_IDENTIFIER = String.format("metrics-librato/%s metrics/%s", metricsLibratoVersion, metricsCoreVersion);
    }

    public static interface DurationConverter {
        public double convertMetricDuration(double var1);
    }

    public static interface RateConverter {
        public double convertMetricRate(double var1);
    }
}

