/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd;

import aQute.bnd.build.ProjectMessages;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.RepositoryPlugin;
import aQute.libg.reporter.ReporterMessages;
import aQute.service.reporter.Reporter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

public class Deployer {
    private final Processor processor;
    final ProjectMessages msgs;

    public Deployer(Processor processor) {
        this.processor = processor;
        this.msgs = (ProjectMessages)ReporterMessages.base((Reporter)this.processor, ProjectMessages.class);
    }

    public void deploy(File file) throws Exception {
        String name = this.processor.getProperty("-deployrepo");
        this.deploy(name, file);
    }

    public void deploy(String name, File file) throws Exception {
        List plugins = this.processor.getPlugins(RepositoryPlugin.class);
        RepositoryPlugin rp = null;
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            if (name == null) {
                rp = plugin;
                break;
            }
            if (!name.equals(plugin.getName())) continue;
            rp = plugin;
            break;
        }
        if (rp != null) {
            try {
                rp.put((InputStream)new BufferedInputStream(new FileInputStream(file)), new RepositoryPlugin.PutOptions());
                return;
            }
            catch (Exception e) {
                this.msgs.DeployingFile_On_Exception_(file, rp.getName(), e);
                return;
            }
        }
        this.processor.trace("No repo found " + file, new Object[0]);
        throw new IllegalArgumentException("No repository found for " + file);
    }
}

