/**
 * Copyright (c) 2000-2012 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.wiki.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.GroupedModel;
import com.liferay.portal.service.ServiceContext;

import com.liferay.portlet.expando.model.ExpandoBridge;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the WikiNode service. Represents a row in the &quot;WikiNode&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.portlet.wiki.model.impl.WikiNodeModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.portlet.wiki.model.impl.WikiNodeImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WikiNode
 * @see com.liferay.portlet.wiki.model.impl.WikiNodeImpl
 * @see com.liferay.portlet.wiki.model.impl.WikiNodeModelImpl
 * @generated
 */
public interface WikiNodeModel extends BaseModel<WikiNode>, GroupedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a wiki node model instance should use the {@link WikiNode} interface instead.
	 */

	/**
	 * Returns the primary key of this wiki node.
	 *
	 * @return the primary key of this wiki node
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this wiki node.
	 *
	 * @param primaryKey the primary key of this wiki node
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this wiki node.
	 *
	 * @return the uuid of this wiki node
	 */
	@AutoEscape
	public String getUuid();

	/**
	 * Sets the uuid of this wiki node.
	 *
	 * @param uuid the uuid of this wiki node
	 */
	public void setUuid(String uuid);

	/**
	 * Returns the node ID of this wiki node.
	 *
	 * @return the node ID of this wiki node
	 */
	public long getNodeId();

	/**
	 * Sets the node ID of this wiki node.
	 *
	 * @param nodeId the node ID of this wiki node
	 */
	public void setNodeId(long nodeId);

	/**
	 * Returns the group ID of this wiki node.
	 *
	 * @return the group ID of this wiki node
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this wiki node.
	 *
	 * @param groupId the group ID of this wiki node
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this wiki node.
	 *
	 * @return the company ID of this wiki node
	 */
	public long getCompanyId();

	/**
	 * Sets the company ID of this wiki node.
	 *
	 * @param companyId the company ID of this wiki node
	 */
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this wiki node.
	 *
	 * @return the user ID of this wiki node
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this wiki node.
	 *
	 * @param userId the user ID of this wiki node
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this wiki node.
	 *
	 * @return the user uuid of this wiki node
	 * @throws SystemException if a system exception occurred
	 */
	public String getUserUuid() throws SystemException;

	/**
	 * Sets the user uuid of this wiki node.
	 *
	 * @param userUuid the user uuid of this wiki node
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this wiki node.
	 *
	 * @return the user name of this wiki node
	 */
	@AutoEscape
	public String getUserName();

	/**
	 * Sets the user name of this wiki node.
	 *
	 * @param userName the user name of this wiki node
	 */
	public void setUserName(String userName);

	/**
	 * Returns the create date of this wiki node.
	 *
	 * @return the create date of this wiki node
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this wiki node.
	 *
	 * @param createDate the create date of this wiki node
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this wiki node.
	 *
	 * @return the modified date of this wiki node
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this wiki node.
	 *
	 * @param modifiedDate the modified date of this wiki node
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the name of this wiki node.
	 *
	 * @return the name of this wiki node
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this wiki node.
	 *
	 * @param name the name of this wiki node
	 */
	public void setName(String name);

	/**
	 * Returns the description of this wiki node.
	 *
	 * @return the description of this wiki node
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this wiki node.
	 *
	 * @param description the description of this wiki node
	 */
	public void setDescription(String description);

	/**
	 * Returns the last post date of this wiki node.
	 *
	 * @return the last post date of this wiki node
	 */
	public Date getLastPostDate();

	/**
	 * Sets the last post date of this wiki node.
	 *
	 * @param lastPostDate the last post date of this wiki node
	 */
	public void setLastPostDate(Date lastPostDate);

	public boolean isNew();

	public void setNew(boolean n);

	public boolean isCachedModel();

	public void setCachedModel(boolean cachedModel);

	public boolean isEscapedModel();

	public Serializable getPrimaryKeyObj();

	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	public ExpandoBridge getExpandoBridge();

	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	public Object clone();

	public int compareTo(WikiNode wikiNode);

	public int hashCode();

	public CacheModel<WikiNode> toCacheModel();

	public WikiNode toEscapedModel();

	public String toString();

	public String toXmlString();
}