/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model;

import java.io.Serializable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * This class is used by SOAP remote services.
 *
 * @author    Brian Wing Shun Chan
 * @generated
 */
public class PortletItemSoap implements Serializable {
	public static PortletItemSoap toSoapModel(PortletItem model) {
		PortletItemSoap soapModel = new PortletItemSoap();

		soapModel.setPortletItemId(model.getPortletItemId());
		soapModel.setGroupId(model.getGroupId());
		soapModel.setCompanyId(model.getCompanyId());
		soapModel.setUserId(model.getUserId());
		soapModel.setUserName(model.getUserName());
		soapModel.setCreateDate(model.getCreateDate());
		soapModel.setModifiedDate(model.getModifiedDate());
		soapModel.setName(model.getName());
		soapModel.setPortletId(model.getPortletId());
		soapModel.setClassNameId(model.getClassNameId());

		return soapModel;
	}

	public static PortletItemSoap[] toSoapModels(PortletItem[] models) {
		PortletItemSoap[] soapModels = new PortletItemSoap[models.length];

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModel(models[i]);
		}

		return soapModels;
	}

	public static PortletItemSoap[][] toSoapModels(PortletItem[][] models) {
		PortletItemSoap[][] soapModels = null;

		if (models.length > 0) {
			soapModels = new PortletItemSoap[models.length][models[0].length];
		}
		else {
			soapModels = new PortletItemSoap[0][0];
		}

		for (int i = 0; i < models.length; i++) {
			soapModels[i] = toSoapModels(models[i]);
		}

		return soapModels;
	}

	public static PortletItemSoap[] toSoapModels(List<PortletItem> models) {
		List<PortletItemSoap> soapModels = new ArrayList<PortletItemSoap>(models.size());

		for (PortletItem model : models) {
			soapModels.add(toSoapModel(model));
		}

		return soapModels.toArray(new PortletItemSoap[soapModels.size()]);
	}

	public PortletItemSoap() {
	}

	public long getPrimaryKey() {
		return _portletItemId;
	}

	public void setPrimaryKey(long pk) {
		setPortletItemId(pk);
	}

	public long getPortletItemId() {
		return _portletItemId;
	}

	public void setPortletItemId(long portletItemId) {
		_portletItemId = portletItemId;
	}

	public long getGroupId() {
		return _groupId;
	}

	public void setGroupId(long groupId) {
		_groupId = groupId;
	}

	public long getCompanyId() {
		return _companyId;
	}

	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	public long getUserId() {
		return _userId;
	}

	public void setUserId(long userId) {
		_userId = userId;
	}

	public String getUserName() {
		return _userName;
	}

	public void setUserName(String userName) {
		_userName = userName;
	}

	public Date getCreateDate() {
		return _createDate;
	}

	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		_modifiedDate = modifiedDate;
	}

	public String getName() {
		return _name;
	}

	public void setName(String name) {
		_name = name;
	}

	public String getPortletId() {
		return _portletId;
	}

	public void setPortletId(String portletId) {
		_portletId = portletId;
	}

	public long getClassNameId() {
		return _classNameId;
	}

	public void setClassNameId(long classNameId) {
		_classNameId = classNameId;
	}

	private long _portletItemId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private String _name;
	private String _portletId;
	private long _classNameId;
}