/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.change.tracking.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CTComment service. Represents a row in the &quot;CTComment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.change.tracking.model.impl.CTCommentModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.change.tracking.model.impl.CTCommentImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTComment
 * @generated
 */
@ProviderType
public interface CTCommentModel
	extends BaseModel<CTComment>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a ct comment model instance should use the {@link CTComment} interface instead.
	 */

	/**
	 * Returns the primary key of this ct comment.
	 *
	 * @return the primary key of this ct comment
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this ct comment.
	 *
	 * @param primaryKey the primary key of this ct comment
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this ct comment.
	 *
	 * @return the mvcc version of this ct comment
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this ct comment.
	 *
	 * @param mvccVersion the mvcc version of this ct comment
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct comment ID of this ct comment.
	 *
	 * @return the ct comment ID of this ct comment
	 */
	public long getCtCommentId();

	/**
	 * Sets the ct comment ID of this ct comment.
	 *
	 * @param ctCommentId the ct comment ID of this ct comment
	 */
	public void setCtCommentId(long ctCommentId);

	/**
	 * Returns the company ID of this ct comment.
	 *
	 * @return the company ID of this ct comment
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this ct comment.
	 *
	 * @param companyId the company ID of this ct comment
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this ct comment.
	 *
	 * @return the user ID of this ct comment
	 */
	public long getUserId();

	/**
	 * Sets the user ID of this ct comment.
	 *
	 * @param userId the user ID of this ct comment
	 */
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this ct comment.
	 *
	 * @return the user uuid of this ct comment
	 */
	public String getUserUuid();

	/**
	 * Sets the user uuid of this ct comment.
	 *
	 * @param userUuid the user uuid of this ct comment
	 */
	public void setUserUuid(String userUuid);

	/**
	 * Returns the create date of this ct comment.
	 *
	 * @return the create date of this ct comment
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this ct comment.
	 *
	 * @param createDate the create date of this ct comment
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this ct comment.
	 *
	 * @return the modified date of this ct comment
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this ct comment.
	 *
	 * @param modifiedDate the modified date of this ct comment
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the ct collection ID of this ct comment.
	 *
	 * @return the ct collection ID of this ct comment
	 */
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this ct comment.
	 *
	 * @param ctCollectionId the ct collection ID of this ct comment
	 */
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the ct entry ID of this ct comment.
	 *
	 * @return the ct entry ID of this ct comment
	 */
	public long getCtEntryId();

	/**
	 * Sets the ct entry ID of this ct comment.
	 *
	 * @param ctEntryId the ct entry ID of this ct comment
	 */
	public void setCtEntryId(long ctEntryId);

	/**
	 * Returns the value of this ct comment.
	 *
	 * @return the value of this ct comment
	 */
	@AutoEscape
	public String getValue();

	/**
	 * Sets the value of this ct comment.
	 *
	 * @param value the value of this ct comment
	 */
	public void setValue(String value);

}