/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.product.util;

import aQute.bnd.annotation.ProviderType;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;

import java.util.Locale;

/**
 * @author Marco Leo
 */
@ProviderType
public interface DDMFormValuesHelper {

	/**
	 * @deprecated As of Mueller (7.2.x), without direct replacement, as this
	 * processing is no longer necessary
	 */
	@Deprecated
	public String cleanDDMFormValuesJSON(String json) throws PortalException;

	public DDMFormValues deserialize(
			DDMForm ddmForm, String json, Locale locale)
		throws PortalException;

	/**
	 * @param json1
	 * @param json2
	 * @return
	 *
	 * @throws PortalException
	 * @deprecated As of Athanasius (7.3.x), use {@link java.util.Objects#equals(String, String)}
	 */
	@Deprecated
	public boolean equals(String json1, String json2) throws PortalException;

	public String serialize(DDMFormValues ddmFormValues);

}