/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the DDMField service. Represents a row in the &quot;DDMField&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.dynamic.data.mapping.model.impl.DDMFieldModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.dynamic.data.mapping.model.impl.DDMFieldImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMField
 * @generated
 */
@ProviderType
public interface DDMFieldModel
	extends BaseModel<DDMField>, CTModel<DDMField>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a ddm field model instance should use the {@link DDMField} interface instead.
	 */

	/**
	 * Returns the primary key of this ddm field.
	 *
	 * @return the primary key of this ddm field
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this ddm field.
	 *
	 * @param primaryKey the primary key of this ddm field
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this ddm field.
	 *
	 * @return the mvcc version of this ddm field
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this ddm field.
	 *
	 * @param mvccVersion the mvcc version of this ddm field
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this ddm field.
	 *
	 * @return the ct collection ID of this ddm field
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this ddm field.
	 *
	 * @param ctCollectionId the ct collection ID of this ddm field
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the field ID of this ddm field.
	 *
	 * @return the field ID of this ddm field
	 */
	public long getFieldId();

	/**
	 * Sets the field ID of this ddm field.
	 *
	 * @param fieldId the field ID of this ddm field
	 */
	public void setFieldId(long fieldId);

	/**
	 * Returns the company ID of this ddm field.
	 *
	 * @return the company ID of this ddm field
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this ddm field.
	 *
	 * @param companyId the company ID of this ddm field
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the parent field ID of this ddm field.
	 *
	 * @return the parent field ID of this ddm field
	 */
	public long getParentFieldId();

	/**
	 * Sets the parent field ID of this ddm field.
	 *
	 * @param parentFieldId the parent field ID of this ddm field
	 */
	public void setParentFieldId(long parentFieldId);

	/**
	 * Returns the storage ID of this ddm field.
	 *
	 * @return the storage ID of this ddm field
	 */
	public long getStorageId();

	/**
	 * Sets the storage ID of this ddm field.
	 *
	 * @param storageId the storage ID of this ddm field
	 */
	public void setStorageId(long storageId);

	/**
	 * Returns the structure version ID of this ddm field.
	 *
	 * @return the structure version ID of this ddm field
	 */
	public long getStructureVersionId();

	/**
	 * Sets the structure version ID of this ddm field.
	 *
	 * @param structureVersionId the structure version ID of this ddm field
	 */
	public void setStructureVersionId(long structureVersionId);

	/**
	 * Returns the field name of this ddm field.
	 *
	 * @return the field name of this ddm field
	 */
	@AutoEscape
	public String getFieldName();

	/**
	 * Sets the field name of this ddm field.
	 *
	 * @param fieldName the field name of this ddm field
	 */
	public void setFieldName(String fieldName);

	/**
	 * Returns the field type of this ddm field.
	 *
	 * @return the field type of this ddm field
	 */
	@AutoEscape
	public String getFieldType();

	/**
	 * Sets the field type of this ddm field.
	 *
	 * @param fieldType the field type of this ddm field
	 */
	public void setFieldType(String fieldType);

	/**
	 * Returns the instance ID of this ddm field.
	 *
	 * @return the instance ID of this ddm field
	 */
	@AutoEscape
	public String getInstanceId();

	/**
	 * Sets the instance ID of this ddm field.
	 *
	 * @param instanceId the instance ID of this ddm field
	 */
	public void setInstanceId(String instanceId);

	/**
	 * Returns the localizable of this ddm field.
	 *
	 * @return the localizable of this ddm field
	 */
	public boolean getLocalizable();

	/**
	 * Returns <code>true</code> if this ddm field is localizable.
	 *
	 * @return <code>true</code> if this ddm field is localizable; <code>false</code> otherwise
	 */
	public boolean isLocalizable();

	/**
	 * Sets whether this ddm field is localizable.
	 *
	 * @param localizable the localizable of this ddm field
	 */
	public void setLocalizable(boolean localizable);

	/**
	 * Returns the priority of this ddm field.
	 *
	 * @return the priority of this ddm field
	 */
	public int getPriority();

	/**
	 * Sets the priority of this ddm field.
	 *
	 * @param priority the priority of this ddm field
	 */
	public void setPriority(int priority);

}