/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.workflow.kaleo.designer.web.constants;

/**
 * Provides the portlet IDs for the available Kaleo Designer portlets.
 *
 * @author Marcellus Tavares
 */
public class KaleoDesignerPortletKeys {

	/**
	 * {@value #CONTROL_PANEL_WORKFLOW} is the portlet ID for the Control Panel
	 * Workflow portlet.
	 */
	public static final String CONTROL_PANEL_WORKFLOW =
		"com_liferay_portal_workflow_web_portlet_ControlPanelWorkflowPortlet";

	public static final String CONTROL_PANEL_WORKFLOW_INSTANCE =
		"com_liferay_portal_workflow_web_internal_portlet_" +
			"ControlPanelWorkflowInstancePortlet";

	/**
	 * {@value #KALEO_DESIGNER} is the portlet ID for the Kaleo Designer
	 * portlet.
	 */
	public static final String KALEO_DESIGNER =
		"com_liferay_portal_workflow_kaleo_designer_web_portlet_" +
			"KaleoDesignerPortlet";

}