/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.asset.model.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;

import java.util.ArrayList;
import java.util.List;

/**
 * The extended model base implementation for the AssetCategory service. Represents a row in the &quot;AssetCategory&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AssetCategoryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AssetCategoryImpl
 * @see AssetCategory
 * @generated
 */
public abstract class AssetCategoryBaseImpl
	extends AssetCategoryModelImpl implements AssetCategory {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a asset category model instance should use the <code>AssetCategory</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			AssetCategoryLocalServiceUtil.addAssetCategory(this);
		}
		else {
			AssetCategoryLocalServiceUtil.updateAssetCategory(this);
		}
	}

	@Override
	@SuppressWarnings("unused")
	public String buildTreePath() throws PortalException {
		List<AssetCategory> assetCategories = new ArrayList<AssetCategory>();

		AssetCategory assetCategory = this;

		while (assetCategory != null) {
			assetCategories.add(assetCategory);

			assetCategory = AssetCategoryLocalServiceUtil.fetchAssetCategory(
				assetCategory.getParentCategoryId());
		}

		StringBundler sb = new StringBundler((assetCategories.size() * 2) + 1);

		sb.append("/");

		for (int i = assetCategories.size() - 1; i >= 0; i--) {
			assetCategory = assetCategories.get(i);

			sb.append(assetCategory.getCategoryId());
			sb.append("/");
		}

		return sb.toString();
	}

	@Override
	public void updateTreePath(String treePath) {
		AssetCategory assetCategory = this;

		assetCategory.setTreePath(treePath);

		AssetCategoryLocalServiceUtil.updateAssetCategory(assetCategory);
	}

}