/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.style.book.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.model.version.VersionModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the StyleBookEntryVersion service. Represents a row in the &quot;StyleBookEntryVersion&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.style.book.model.impl.StyleBookEntryVersionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.style.book.model.impl.StyleBookEntryVersionImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see StyleBookEntryVersion
 * @generated
 */
@ProviderType
public interface StyleBookEntryVersionModel
	extends BaseModel<StyleBookEntryVersion>, CTModel<StyleBookEntryVersion>,
			GroupedModel, MVCCModel, ShardedModel,
			VersionModel<StyleBookEntry> {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a style book entry version model instance should use the {@link StyleBookEntryVersion} interface instead.
	 */

	/**
	 * Returns the primary key of this style book entry version.
	 *
	 * @return the primary key of this style book entry version
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this style book entry version.
	 *
	 * @param primaryKey the primary key of this style book entry version
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this style book entry version.
	 *
	 * @return the mvcc version of this style book entry version
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this style book entry version.
	 *
	 * @param mvccVersion the mvcc version of this style book entry version
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this style book entry version.
	 *
	 * @return the ct collection ID of this style book entry version
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this style book entry version.
	 *
	 * @param ctCollectionId the ct collection ID of this style book entry version
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the style book entry version ID of this style book entry version.
	 *
	 * @return the style book entry version ID of this style book entry version
	 */
	public long getStyleBookEntryVersionId();

	/**
	 * Sets the style book entry version ID of this style book entry version.
	 *
	 * @param styleBookEntryVersionId the style book entry version ID of this style book entry version
	 */
	public void setStyleBookEntryVersionId(long styleBookEntryVersionId);

	/**
	 * Returns the version of this style book entry version.
	 *
	 * @return the version of this style book entry version
	 */
	@Override
	public int getVersion();

	/**
	 * Sets the version of this style book entry version.
	 *
	 * @param version the version of this style book entry version
	 */
	@Override
	public void setVersion(int version);

	/**
	 * Returns the uuid of this style book entry version.
	 *
	 * @return the uuid of this style book entry version
	 */
	@AutoEscape
	public String getUuid();

	/**
	 * Sets the uuid of this style book entry version.
	 *
	 * @param uuid the uuid of this style book entry version
	 */
	public void setUuid(String uuid);

	/**
	 * Returns the style book entry ID of this style book entry version.
	 *
	 * @return the style book entry ID of this style book entry version
	 */
	public long getStyleBookEntryId();

	/**
	 * Sets the style book entry ID of this style book entry version.
	 *
	 * @param styleBookEntryId the style book entry ID of this style book entry version
	 */
	public void setStyleBookEntryId(long styleBookEntryId);

	/**
	 * Returns the group ID of this style book entry version.
	 *
	 * @return the group ID of this style book entry version
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this style book entry version.
	 *
	 * @param groupId the group ID of this style book entry version
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this style book entry version.
	 *
	 * @return the company ID of this style book entry version
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this style book entry version.
	 *
	 * @param companyId the company ID of this style book entry version
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this style book entry version.
	 *
	 * @return the user ID of this style book entry version
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this style book entry version.
	 *
	 * @param userId the user ID of this style book entry version
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this style book entry version.
	 *
	 * @return the user uuid of this style book entry version
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this style book entry version.
	 *
	 * @param userUuid the user uuid of this style book entry version
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this style book entry version.
	 *
	 * @return the user name of this style book entry version
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this style book entry version.
	 *
	 * @param userName the user name of this style book entry version
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this style book entry version.
	 *
	 * @return the create date of this style book entry version
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this style book entry version.
	 *
	 * @param createDate the create date of this style book entry version
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this style book entry version.
	 *
	 * @return the modified date of this style book entry version
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this style book entry version.
	 *
	 * @param modifiedDate the modified date of this style book entry version
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the default style book entry of this style book entry version.
	 *
	 * @return the default style book entry of this style book entry version
	 */
	public boolean getDefaultStyleBookEntry();

	/**
	 * Returns <code>true</code> if this style book entry version is default style book entry.
	 *
	 * @return <code>true</code> if this style book entry version is default style book entry; <code>false</code> otherwise
	 */
	public boolean isDefaultStyleBookEntry();

	/**
	 * Sets whether this style book entry version is default style book entry.
	 *
	 * @param defaultStyleBookEntry the default style book entry of this style book entry version
	 */
	public void setDefaultStyleBookEntry(boolean defaultStyleBookEntry);

	/**
	 * Returns the frontend tokens values of this style book entry version.
	 *
	 * @return the frontend tokens values of this style book entry version
	 */
	@AutoEscape
	public String getFrontendTokensValues();

	/**
	 * Sets the frontend tokens values of this style book entry version.
	 *
	 * @param frontendTokensValues the frontend tokens values of this style book entry version
	 */
	public void setFrontendTokensValues(String frontendTokensValues);

	/**
	 * Returns the name of this style book entry version.
	 *
	 * @return the name of this style book entry version
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this style book entry version.
	 *
	 * @param name the name of this style book entry version
	 */
	public void setName(String name);

	/**
	 * Returns the preview file entry ID of this style book entry version.
	 *
	 * @return the preview file entry ID of this style book entry version
	 */
	public long getPreviewFileEntryId();

	/**
	 * Sets the preview file entry ID of this style book entry version.
	 *
	 * @param previewFileEntryId the preview file entry ID of this style book entry version
	 */
	public void setPreviewFileEntryId(long previewFileEntryId);

	/**
	 * Returns the style book entry key of this style book entry version.
	 *
	 * @return the style book entry key of this style book entry version
	 */
	@AutoEscape
	public String getStyleBookEntryKey();

	/**
	 * Sets the style book entry key of this style book entry version.
	 *
	 * @param styleBookEntryKey the style book entry key of this style book entry version
	 */
	public void setStyleBookEntryKey(String styleBookEntryKey);

}