/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AlertRemote;
import com.machinepublishers.jbrowserdriver.ContextItem;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.TimeoutsServer;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.event.EventHandler;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEvent;
import javafx.util.Callback;
import org.openqa.selenium.Alert;

class AlertServer
extends RemoteObject
implements AlertRemote,
Alert {
    private static final String NO_TEXT_VALUE = "no-text-value";
    private final Object lock = new Object();
    private final AtomicReference<TimeoutsServer> timeouts;
    private final AtomicReference<String> text = new AtomicReference<String>("no-text-value");
    private final LinkedList<String> inputs = new LinkedList();
    private final AtomicInteger dismissQueue = new AtomicInteger();
    private final AtomicInteger acceptQueue = new AtomicInteger();
    private final AlertHandler alertHandler = new AlertHandler();
    private final ConfirmHandler confirmHandler = new ConfirmHandler();
    private final PromptHandler promptHandler = new PromptHandler();

    AlertServer(AtomicReference<TimeoutsServer> timeouts) throws RemoteException {
        this.timeouts = timeouts;
    }

    void listen(ContextItem item) {
        if (!SettingsManager.settings().ignoreDialogs()) {
            item.engine.get().setOnAlert((EventHandler)this.alertHandler);
            item.engine.get().setConfirmHandler((Callback)this.confirmHandler);
            item.engine.get().setPromptHandler((Callback)this.promptHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept() {
        Object object = this.lock;
        synchronized (object) {
            this.text.set(NO_TEXT_VALUE);
            this.acceptQueue.incrementAndGet();
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismiss() {
        Object object = this.lock;
        synchronized (object) {
            this.text.set(NO_TEXT_VALUE);
            this.dismissQueue.incrementAndGet();
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText() {
        Object object = this.lock;
        synchronized (object) {
            if (this.text.get() == NO_TEXT_VALUE) {
                try {
                    this.lock.wait(this.timeouts.get().getAlertTimeoutMS());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.text.get() == NO_TEXT_VALUE ? null : this.text.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendKeys(String text) {
        Object object = this.lock;
        synchronized (object) {
            this.inputs.add(text);
        }
    }

    private final class PromptHandler
    implements Callback<PromptData, String> {
        private PromptHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String call(PromptData param) {
            boolean accept = false;
            Object object = AlertServer.this.lock;
            synchronized (object) {
                AlertServer.this.text.set(param.getMessage());
                AlertServer.this.lock.notifyAll();
                boolean initial = true;
                block5: while (true) {
                    try {
                        while (true) {
                            if (AlertServer.this.dismissQueue.get() > 0) {
                                AlertServer.this.dismissQueue.decrementAndGet();
                                accept = false;
                                break block5;
                            }
                            if (AlertServer.this.acceptQueue.get() > 0) {
                                AlertServer.this.acceptQueue.decrementAndGet();
                                accept = true;
                                break block5;
                            }
                            if (!initial) break block5;
                            AlertServer.this.lock.wait(((TimeoutsServer)AlertServer.this.timeouts.get()).getAlertTimeoutMS());
                            initial = false;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                AlertServer.this.text.set(AlertServer.NO_TEXT_VALUE);
                return accept && !AlertServer.this.inputs.isEmpty() ? (String)AlertServer.this.inputs.removeFirst() : null;
            }
        }
    }

    private final class ConfirmHandler
    implements Callback<String, Boolean> {
        private ConfirmHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean call(String param) {
            boolean accept = true;
            Object object = AlertServer.this.lock;
            synchronized (object) {
                AlertServer.this.text.set(param);
                AlertServer.this.lock.notifyAll();
                boolean initial = true;
                block5: while (true) {
                    try {
                        while (true) {
                            if (AlertServer.this.dismissQueue.get() > 0) {
                                AlertServer.this.dismissQueue.decrementAndGet();
                                accept = false;
                                break block5;
                            }
                            if (AlertServer.this.acceptQueue.get() > 0) {
                                AlertServer.this.acceptQueue.decrementAndGet();
                                accept = true;
                                break block5;
                            }
                            if (!initial) break block5;
                            AlertServer.this.lock.wait(((TimeoutsServer)AlertServer.this.timeouts.get()).getAlertTimeoutMS());
                            initial = false;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                AlertServer.this.text.set(AlertServer.NO_TEXT_VALUE);
            }
            return accept;
        }
    }

    private final class AlertHandler
    implements EventHandler<WebEvent<String>> {
        private AlertHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(WebEvent<String> event) {
            Object object = AlertServer.this.lock;
            synchronized (object) {
                AlertServer.this.text.set(event.getData());
                AlertServer.this.lock.notifyAll();
                boolean initial = true;
                block5: while (true) {
                    try {
                        while (true) {
                            if (AlertServer.this.dismissQueue.get() > 0) {
                                AlertServer.this.dismissQueue.decrementAndGet();
                                break block5;
                            }
                            if (AlertServer.this.acceptQueue.get() > 0) {
                                AlertServer.this.acceptQueue.decrementAndGet();
                                break block5;
                            }
                            if (!initial) break block5;
                            AlertServer.this.lock.wait(((TimeoutsServer)AlertServer.this.timeouts.get()).getAlertTimeoutMS());
                            initial = false;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                AlertServer.this.text.set(AlertServer.NO_TEXT_VALUE);
            }
        }
    }
}

