/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class LogHandler
extends Handler {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    LogHandler() {
    }

    @Override
    public void publish(LogRecord record) {
        String message = "[" + dateFormat.format(new Date(record.getMillis())) + "]" + record.getMessage();
        if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

