/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver.diagnostics;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;

public class HttpServer {
    private static final AtomicBoolean loop = new AtomicBoolean();
    private static final AtomicReference<Closeable> listener = new AtomicReference();
    private static final AtomicReference<List<String>> previousRequest = new AtomicReference();
    private static final AtomicLong previousRequestId = new AtomicLong();
    private static final byte[] indexBody;
    private static final byte[] indexContent;
    private static final byte[] postBody;
    private static final byte[] postContent;
    private static final byte[] iframeBody;
    private static final byte[] iframeContent;
    private static final byte[] redirectContent;
    private static final byte[] imageBody;
    private static final byte[] imageContent;

    private static byte[][] resource(String path, String status, String contentType) {
        byte[] bodyTmp = null;
        byte[] contentTmp = null;
        try (InputStream inputStream = HttpServer.class.getResourceAsStream(path);){
            bodyTmp = IOUtils.toByteArray((InputStream)inputStream);
            contentTmp = new String("HTTP/1.1 " + status + "\nContent-Length: " + bodyTmp.length + "\n" + (contentType == null ? "" : "Content-Type: " + contentType + "\n") + "Expires: Sun, 09 Feb 2116 01:01:01 GMT\nConnection: close\n\n").getBytes("utf-8");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new byte[][]{bodyTmp, contentTmp};
    }

    public static List<String> previousRequest() {
        return previousRequest.get();
    }

    public static long previousRequestId() {
        return previousRequestId.get();
    }

    public static void launch(final int port) {
        if (loop.compareAndSet(false, true)) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try (ServerSocket serverSocket = new ServerSocket(port, 50, InetAddress.getLoopbackAddress());){
                        listener.set(serverSocket);
                        while (loop.get()) {
                            Socket socket = serverSocket.accept();
                            Throwable throwable = null;
                            try {
                                DataOutputStream output = new DataOutputStream(socket.getOutputStream());
                                Throwable throwable2 = null;
                                try {
                                    BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                                    Throwable throwable3 = null;
                                    try {
                                        String line;
                                        ArrayList<String> request = new ArrayList<String>();
                                        while ((line = reader.readLine()) != null) {
                                            request.add(line);
                                            if (line.startsWith("GET / ")) {
                                                output.write(indexContent, 0, indexContent.length);
                                                output.write(indexBody, 0, indexBody.length);
                                                continue;
                                            }
                                            if (line.startsWith("POST / ")) {
                                                output.write(postContent, 0, postContent.length);
                                                output.write(postBody, 0, postBody.length);
                                                continue;
                                            }
                                            if (line.startsWith("GET /iframe.htm")) {
                                                output.write(iframeContent, 0, iframeContent.length);
                                                output.write(iframeBody, 0, iframeBody.length);
                                                continue;
                                            }
                                            if (line.startsWith("GET /redirect/site1 ")) {
                                                output.write(redirectContent);
                                                continue;
                                            }
                                            if (line.startsWith("GET /redirect/site2 ")) {
                                                output.write(iframeContent, 0, iframeContent.length);
                                                output.write(iframeBody, 0, iframeBody.length);
                                                continue;
                                            }
                                            if (line.startsWith("GET /wait-forever ")) {
                                                Class<HttpServer> clazz = HttpServer.class;
                                                // MONITORENTER : com.machinepublishers.jbrowserdriver.diagnostics.HttpServer.class
                                                HttpServer.class.wait();
                                                // MONITOREXIT : clazz
                                                continue;
                                            }
                                            if (!line.startsWith("GET /image.png")) continue;
                                            output.write(imageContent, 0, imageContent.length);
                                            output.write(imageBody, 0, imageBody.length);
                                        }
                                        previousRequest.set(request);
                                        previousRequestId.incrementAndGet();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        if (reader == null) continue;
                                        if (throwable3 != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable3.addSuppressed(throwable5);
                                            }
                                            continue;
                                        }
                                        reader.close();
                                    }
                                }
                                catch (Throwable throwable6) {
                                    throwable2 = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    if (output == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            output.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable2.addSuppressed(throwable7);
                                        }
                                        continue;
                                    }
                                    output.close();
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable = throwable8;
                                throw throwable8;
                            }
                            finally {
                                if (socket == null) continue;
                                if (throwable != null) {
                                    try {
                                        socket.close();
                                    }
                                    catch (Throwable throwable9) {
                                        throwable.addSuppressed(throwable9);
                                    }
                                    continue;
                                }
                                socket.close();
                            }
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        loop.set(false);
        Class<HttpServer> clazz = HttpServer.class;
        synchronized (HttpServer.class) {
            HttpServer.class.notifyAll();
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                listener.get().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
    }

    static {
        byte[][] resource = HttpServer.resource("/com/machinepublishers/jbrowserdriver/diagnostics/test.htm", "200 OK", null);
        indexBody = resource[0];
        indexContent = resource[1];
        resource = HttpServer.resource("/com/machinepublishers/jbrowserdriver/diagnostics/test.htm", "201 Created", null);
        postBody = resource[0];
        postContent = resource[1];
        resource = HttpServer.resource("/com/machinepublishers/jbrowserdriver/diagnostics/iframe.htm", "200 OK", null);
        iframeBody = resource[0];
        iframeContent = resource[1];
        resource = HttpServer.resource("/com/machinepublishers/jbrowserdriver/diagnostics/image.png", "200 OK", "image/png");
        imageBody = resource[0];
        imageContent = resource[1];
        byte[] redirectContentTmp = null;
        try {
            redirectContentTmp = new String("HTTP/1.1 302 Found\nServer: Initech/1.1\nX-FRAME-OPTIONS: SAMEORIGIN\nSet-Cookie: JSESSIONID=ABC123; Path=/redirect/; HttpOnly\nExpires: 0\nCache-Control: no-store, no-cache\nCache-Control: post-check=0, pre-check=0\nPragma: no-cache\nLocation: /redirect/site2\nContent-Type: text/html;charset=UTF-8\nContent-Length: 0\n\n").getBytes("utf-8");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        redirectContent = redirectContentTmp;
    }
}

