/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.bcpg.sig;

import org.spongycastle.bcpg.SignatureSubpacket;
import org.spongycastle.util.Strings;

public class RevocationReason
extends SignatureSubpacket {
    public RevocationReason(boolean isCritical, boolean isLongLength, byte[] data) {
        super(29, isCritical, isLongLength, data);
    }

    public RevocationReason(boolean isCritical, byte reason, String description) {
        super(29, isCritical, false, RevocationReason.createData(reason, description));
    }

    private static byte[] createData(byte reason, String description) {
        byte[] descriptionBytes = Strings.toUTF8ByteArray((String)description);
        byte[] data = new byte[1 + descriptionBytes.length];
        data[0] = reason;
        System.arraycopy(descriptionBytes, 0, data, 1, descriptionBytes.length);
        return data;
    }

    public byte getRevocationReason() {
        return this.getData()[0];
    }

    public String getRevocationDescription() {
        byte[] data = this.getData();
        if (data.length == 1) {
            return "";
        }
        byte[] description = new byte[data.length - 1];
        System.arraycopy(data, 1, description, 0, description.length);
        return Strings.fromUTF8ByteArray((byte[])description);
    }
}

