/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spongycastle.bcpg.BCPGOutputStream;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPObjectFactory;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPPublicKeyRing;
import org.spongycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.spongycastle.util.Iterable;
import org.spongycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGPPublicKeyRingCollection
implements Iterable<PGPPublicKeyRing> {
    private Map pubRings = new HashMap();
    private List order = new ArrayList();

    private PGPPublicKeyRingCollection(Map pubRings, List order) {
        this.pubRings = pubRings;
        this.order = order;
    }

    public PGPPublicKeyRingCollection(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    public PGPPublicKeyRingCollection(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        Object obj;
        PGPObjectFactory pgpFact = new PGPObjectFactory(in, fingerPrintCalculator);
        while ((obj = pgpFact.nextObject()) != null) {
            if (!(obj instanceof PGPPublicKeyRing)) {
                throw new PGPException(obj.getClass().getName() + " found where PGPPublicKeyRing expected");
            }
            PGPPublicKeyRing pgpPub = (PGPPublicKeyRing)obj;
            Long key = new Long(pgpPub.getPublicKey().getKeyID());
            this.pubRings.put(key, pgpPub);
            this.order.add(key);
        }
    }

    public PGPPublicKeyRingCollection(Collection<PGPPublicKeyRing> collection) throws IOException, PGPException {
        for (PGPPublicKeyRing pgpPub : collection) {
            Long key = new Long(pgpPub.getPublicKey().getKeyID());
            this.pubRings.put(key, pgpPub);
            this.order.add(key);
        }
    }

    public int size() {
        return this.order.size();
    }

    public Iterator<PGPPublicKeyRing> getKeyRings() {
        return this.pubRings.values().iterator();
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String userID) throws PGPException {
        return this.getKeyRings(userID, false, false);
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String userID, boolean matchPartial) throws PGPException {
        return this.getKeyRings(userID, matchPartial, false);
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String userID, boolean matchPartial, boolean ignoreCase) throws PGPException {
        Iterator<PGPPublicKeyRing> it = this.getKeyRings();
        ArrayList<PGPPublicKeyRing> rings = new ArrayList<PGPPublicKeyRing>();
        if (ignoreCase) {
            userID = Strings.toLowerCase((String)userID);
        }
        while (it.hasNext()) {
            PGPPublicKeyRing pubRing = it.next();
            Iterator uIt = pubRing.getPublicKey().getUserIDs();
            while (uIt.hasNext()) {
                String next = (String)uIt.next();
                if (ignoreCase) {
                    next = Strings.toLowerCase((String)next);
                }
                if (matchPartial) {
                    if (next.indexOf(userID) <= -1) continue;
                    rings.add(pubRing);
                    continue;
                }
                if (!next.equals(userID)) continue;
                rings.add(pubRing);
            }
        }
        return rings.iterator();
    }

    public PGPPublicKey getPublicKey(long keyID) throws PGPException {
        Iterator<PGPPublicKeyRing> it = this.getKeyRings();
        while (it.hasNext()) {
            PGPPublicKeyRing pubRing = it.next();
            PGPPublicKey pub = pubRing.getPublicKey(keyID);
            if (pub == null) continue;
            return pub;
        }
        return null;
    }

    public PGPPublicKeyRing getPublicKeyRing(long keyID) throws PGPException {
        Long id = new Long(keyID);
        if (this.pubRings.containsKey(id)) {
            return (PGPPublicKeyRing)this.pubRings.get(id);
        }
        Iterator<PGPPublicKeyRing> it = this.getKeyRings();
        while (it.hasNext()) {
            PGPPublicKeyRing pubRing = it.next();
            PGPPublicKey pub = pubRing.getPublicKey(keyID);
            if (pub == null) continue;
            return pubRing;
        }
        return null;
    }

    public boolean contains(long keyID) throws PGPException {
        return this.getPublicKey(keyID) != null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        Iterator it = this.order.iterator();
        while (it.hasNext()) {
            PGPPublicKeyRing sr = (PGPPublicKeyRing)this.pubRings.get(it.next());
            sr.encode(out);
        }
    }

    public static PGPPublicKeyRingCollection addPublicKeyRing(PGPPublicKeyRingCollection ringCollection, PGPPublicKeyRing publicKeyRing) {
        Long key = new Long(publicKeyRing.getPublicKey().getKeyID());
        if (ringCollection.pubRings.containsKey(key)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPPublicKeyRing> newPubRings = new HashMap<Long, PGPPublicKeyRing>(ringCollection.pubRings);
        ArrayList<Long> newOrder = new ArrayList<Long>(ringCollection.order);
        newPubRings.put(key, publicKeyRing);
        newOrder.add(key);
        return new PGPPublicKeyRingCollection(newPubRings, newOrder);
    }

    public static PGPPublicKeyRingCollection removePublicKeyRing(PGPPublicKeyRingCollection ringCollection, PGPPublicKeyRing publicKeyRing) {
        Long key = new Long(publicKeyRing.getPublicKey().getKeyID());
        if (!ringCollection.pubRings.containsKey(key)) {
            throw new IllegalArgumentException("Collection does not contain a key with a keyID for the passed in ring.");
        }
        HashMap newPubRings = new HashMap(ringCollection.pubRings);
        ArrayList newOrder = new ArrayList(ringCollection.order);
        newPubRings.remove(key);
        for (int i = 0; i < newOrder.size(); ++i) {
            Long r = (Long)newOrder.get(i);
            if (r.longValue() != key.longValue()) continue;
            newOrder.remove(i);
            break;
        }
        return new PGPPublicKeyRingCollection(newPubRings, newOrder);
    }

    public Iterator<PGPPublicKeyRing> iterator() {
        return this.pubRings.values().iterator();
    }
}

