/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.spongycastle.bcpg.ArmoredOutputStream;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.openpgp.PGPCompressedData;
import org.spongycastle.openpgp.PGPEncryptedDataGenerator;
import org.spongycastle.openpgp.PGPEncryptedDataList;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPLiteralData;
import org.spongycastle.openpgp.PGPPBEEncryptedData;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.examples.PGPExampleUtil;
import org.spongycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.spongycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.spongycastle.util.io.Streams;

public class PBEFileProcessor {
    private static void decryptFile(String inputFileName, char[] passPhrase) throws IOException, NoSuchProviderException, PGPException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFileName));
        PBEFileProcessor.decryptFile(in, passPhrase);
        ((InputStream)in).close();
    }

    private static void decryptFile(InputStream in, char[] passPhrase) throws IOException, NoSuchProviderException, PGPException {
        JcaPGPObjectFactory pgpF = new JcaPGPObjectFactory(in = PGPUtil.getDecoderStream(in));
        Object o = pgpF.nextObject();
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
        PGPPBEEncryptedData pbe = (PGPPBEEncryptedData)enc.get(0);
        InputStream clear = pbe.getDataStream(new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("SC").build()).setProvider("SC").build(passPhrase));
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(clear);
        o = pgpFact.nextObject();
        if (o instanceof PGPCompressedData) {
            PGPCompressedData cData = (PGPCompressedData)o;
            pgpFact = new JcaPGPObjectFactory(cData.getDataStream());
            o = pgpFact.nextObject();
        }
        PGPLiteralData ld = (PGPLiteralData)o;
        InputStream unc = ld.getInputStream();
        BufferedOutputStream fOut = new BufferedOutputStream(new FileOutputStream(ld.getFileName()));
        Streams.pipeAll((InputStream)unc, (OutputStream)fOut);
        ((OutputStream)fOut).close();
        if (pbe.isIntegrityProtected()) {
            if (!pbe.verify()) {
                System.err.println("message failed integrity check");
            } else {
                System.err.println("message integrity check passed");
            }
        } else {
            System.err.println("no message integrity check");
        }
    }

    private static void encryptFile(String outputFileName, String inputFileName, char[] passPhrase, boolean armor, boolean withIntegrityCheck) throws IOException, NoSuchProviderException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFileName));
        PBEFileProcessor.encryptFile(out, inputFileName, passPhrase, armor, withIntegrityCheck);
        ((OutputStream)out).close();
    }

    private static void encryptFile(OutputStream out, String fileName, char[] passPhrase, boolean armor, boolean withIntegrityCheck) throws IOException, NoSuchProviderException {
        block4: {
            if (armor) {
                out = new ArmoredOutputStream(out);
            }
            try {
                byte[] compressedData = PGPExampleUtil.compressFile(fileName, 1);
                PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator(new JcePGPDataEncryptorBuilder(3).setWithIntegrityPacket(withIntegrityCheck).setSecureRandom(new SecureRandom()).setProvider("SC"));
                encGen.addMethod(new JcePBEKeyEncryptionMethodGenerator(passPhrase).setProvider("SC"));
                OutputStream encOut = encGen.open(out, compressedData.length);
                encOut.write(compressedData);
                encOut.close();
                if (armor) {
                    out.close();
                }
            }
            catch (PGPException e) {
                System.err.println(e);
                if (e.getUnderlyingException() == null) break block4;
                e.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args[0].equals("-e")) {
            if (args[1].equals("-a") || args[1].equals("-ai") || args[1].equals("-ia")) {
                PBEFileProcessor.encryptFile(args[2] + ".asc", args[2], args[3].toCharArray(), true, args[1].indexOf(105) > 0);
            } else if (args[1].equals("-i")) {
                PBEFileProcessor.encryptFile(args[2] + ".bpg", args[2], args[3].toCharArray(), false, true);
            } else {
                PBEFileProcessor.encryptFile(args[1] + ".bpg", args[1], args[2].toCharArray(), false, false);
            }
        } else if (args[0].equals("-d")) {
            PBEFileProcessor.decryptFile(args[1], args[2].toCharArray());
        } else {
            System.err.println("usage: PBEFileProcessor -e [-ai]|-d file passPhrase");
        }
    }
}

