/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.spongycastle.bcpg.ArmoredOutputStream;
import org.spongycastle.bcpg.BCPGOutputStream;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.openpgp.PGPCompressedData;
import org.spongycastle.openpgp.PGPCompressedDataGenerator;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPLiteralData;
import org.spongycastle.openpgp.PGPLiteralDataGenerator;
import org.spongycastle.openpgp.PGPOnePassSignature;
import org.spongycastle.openpgp.PGPOnePassSignatureList;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.PGPPublicKeyRingCollection;
import org.spongycastle.openpgp.PGPSecretKey;
import org.spongycastle.openpgp.PGPSignatureGenerator;
import org.spongycastle.openpgp.PGPSignatureList;
import org.spongycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.spongycastle.openpgp.PGPUtil;
import org.spongycastle.openpgp.examples.PGPExampleUtil;
import org.spongycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.spongycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.spongycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.spongycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class SignedFileProcessor {
    private static void verifyFile(InputStream in, InputStream keyIn) throws Exception {
        int ch;
        in = PGPUtil.getDecoderStream(in);
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(in);
        PGPCompressedData c1 = (PGPCompressedData)pgpFact.nextObject();
        pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
        PGPOnePassSignatureList p1 = (PGPOnePassSignatureList)pgpFact.nextObject();
        PGPOnePassSignature ops = p1.get(0);
        PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
        InputStream dIn = p2.getInputStream();
        PGPPublicKeyRingCollection pgpRing = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey key = pgpRing.getPublicKey(ops.getKeyID());
        FileOutputStream out = new FileOutputStream(p2.getFileName());
        ops.init(new JcaPGPContentVerifierBuilderProvider().setProvider("SC"), key);
        while ((ch = dIn.read()) >= 0) {
            ops.update((byte)ch);
            out.write(ch);
        }
        out.close();
        PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
        if (ops.verify(p3.get(0))) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static void signFile(String fileName, InputStream keyIn, OutputStream out, char[] pass, boolean armor) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        int ch;
        if (armor) {
            out = new ArmoredOutputStream(out);
        }
        PGPSecretKey pgpSec = PGPExampleUtil.readSecretKey(keyIn);
        PGPPrivateKey pgpPrivKey = pgpSec.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("SC").build(pass));
        PGPSignatureGenerator sGen = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pgpSec.getPublicKey().getAlgorithm(), 2).setProvider("SC"));
        sGen.init(0, pgpPrivKey);
        Iterator it = pgpSec.getPublicKey().getUserIDs();
        if (it.hasNext()) {
            PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
            spGen.setSignerUserID(false, (String)it.next());
            sGen.setHashedSubpackets(spGen.generate());
        }
        PGPCompressedDataGenerator cGen = new PGPCompressedDataGenerator(2);
        BCPGOutputStream bOut = new BCPGOutputStream(cGen.open(out));
        sGen.generateOnePassVersion(false).encode(bOut);
        File file = new File(fileName);
        PGPLiteralDataGenerator lGen = new PGPLiteralDataGenerator();
        OutputStream lOut = lGen.open(bOut, 'b', file);
        FileInputStream fIn = new FileInputStream(file);
        while ((ch = fIn.read()) >= 0) {
            lOut.write(ch);
            sGen.update((byte)ch);
        }
        lGen.close();
        sGen.generate().encode(bOut);
        cGen.close();
        if (armor) {
            out.close();
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args[0].equals("-s")) {
            if (args[1].equals("-a")) {
                FileInputStream keyIn = new FileInputStream(args[3]);
                FileOutputStream out = new FileOutputStream(args[2] + ".asc");
                SignedFileProcessor.signFile(args[2], keyIn, out, args[4].toCharArray(), true);
            } else {
                FileInputStream keyIn = new FileInputStream(args[2]);
                FileOutputStream out = new FileOutputStream(args[1] + ".bpg");
                SignedFileProcessor.signFile(args[1], keyIn, out, args[3].toCharArray(), false);
            }
        } else if (args[0].equals("-v")) {
            FileInputStream in = new FileInputStream(args[1]);
            FileInputStream keyIn = new FileInputStream(args[2]);
            SignedFileProcessor.verifyFile(in, keyIn);
        } else {
            System.err.println("usage: SignedFileProcessor -v|-s [-a] file keyfile [passPhrase]");
        }
    }
}

