/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator;

import org.spongycastle.bcpg.S2K;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.operator.PGPDigestCalculator;
import org.spongycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.spongycastle.openpgp.operator.PGPUtil;

public abstract class PBESecretKeyDecryptor {
    private char[] passPhrase;
    private PGPDigestCalculatorProvider calculatorProvider;

    protected PBESecretKeyDecryptor(char[] passPhrase, PGPDigestCalculatorProvider calculatorProvider) {
        this.passPhrase = passPhrase;
        this.calculatorProvider = calculatorProvider;
    }

    public PGPDigestCalculator getChecksumCalculator(int hashAlgorithm) throws PGPException {
        return this.calculatorProvider.get(hashAlgorithm);
    }

    public byte[] makeKeyFromPassPhrase(int keyAlgorithm, S2K s2k) throws PGPException {
        return PGPUtil.makeKeyFromPassPhrase(this.calculatorProvider, keyAlgorithm, s2k, this.passPhrase);
    }

    public abstract byte[] recoverKeyData(int var1, byte[] var2, byte[] var3, byte[] var4, int var5, int var6) throws PGPException;
}

