/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.bc;

import java.io.IOException;
import java.util.Date;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.nist.NISTNamedCurves;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.asn1.x9.X9ECPoint;
import org.spongycastle.bcpg.BCPGKey;
import org.spongycastle.bcpg.BCPGObject;
import org.spongycastle.bcpg.DSAPublicBCPGKey;
import org.spongycastle.bcpg.DSASecretBCPGKey;
import org.spongycastle.bcpg.ECDHPublicBCPGKey;
import org.spongycastle.bcpg.ECDSAPublicBCPGKey;
import org.spongycastle.bcpg.ECPublicBCPGKey;
import org.spongycastle.bcpg.ECSecretBCPGKey;
import org.spongycastle.bcpg.ElGamalPublicBCPGKey;
import org.spongycastle.bcpg.ElGamalSecretBCPGKey;
import org.spongycastle.bcpg.PublicKeyPacket;
import org.spongycastle.bcpg.RSAPublicBCPGKey;
import org.spongycastle.bcpg.RSASecretBCPGKey;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.DSAParameters;
import org.spongycastle.crypto.params.DSAPrivateKeyParameters;
import org.spongycastle.crypto.params.DSAPublicKeyParameters;
import org.spongycastle.crypto.params.ECDomainParameters;
import org.spongycastle.crypto.params.ECNamedDomainParameters;
import org.spongycastle.crypto.params.ECPrivateKeyParameters;
import org.spongycastle.crypto.params.ECPublicKeyParameters;
import org.spongycastle.crypto.params.ElGamalParameters;
import org.spongycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.spongycastle.crypto.params.ElGamalPublicKeyParameters;
import org.spongycastle.crypto.params.RSAKeyParameters;
import org.spongycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.spongycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.spongycastle.openpgp.PGPAlgorithmParameters;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.PGPKdfParameters;
import org.spongycastle.openpgp.PGPPrivateKey;
import org.spongycastle.openpgp.PGPPublicKey;
import org.spongycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.spongycastle.openpgp.operator.bc.BcUtil;

public class BcPGPKeyConverter {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PGPPublicKey getPGPPublicKey(int algorithm, PGPAlgorithmParameters algorithmParameters, AsymmetricKeyParameter pubKey, Date time) throws PGPException {
        SubjectPublicKeyInfo keyInfo;
        void var5_15;
        if (pubKey instanceof RSAKeyParameters) {
            RSAKeyParameters rK = (RSAKeyParameters)pubKey;
            RSAPublicBCPGKey rSAPublicBCPGKey = new RSAPublicBCPGKey(rK.getModulus(), rK.getExponent());
            return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        }
        if (pubKey instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dK = (DSAPublicKeyParameters)pubKey;
            DSAParameters dP = dK.getParameters();
            DSAPublicBCPGKey dSAPublicBCPGKey = new DSAPublicBCPGKey(dP.getP(), dP.getQ(), dP.getG(), dK.getY());
            return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        }
        if (pubKey instanceof ElGamalPublicKeyParameters) {
            ElGamalPublicKeyParameters eK = (ElGamalPublicKeyParameters)pubKey;
            ElGamalParameters eS = eK.getParameters();
            ElGamalPublicBCPGKey elGamalPublicBCPGKey = new ElGamalPublicBCPGKey(eS.getP(), eS.getG(), eK.getY());
            return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        }
        if (!(pubKey instanceof ECPublicKeyParameters)) throw new PGPException("unknown key class");
        try {
            keyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)pubKey);
        }
        catch (IOException e) {
            throw new PGPException("Unable to encode key: " + e.getMessage(), e);
        }
        ASN1ObjectIdentifier curveOid = ASN1ObjectIdentifier.getInstance((Object)keyInfo.getAlgorithm().getParameters());
        X9ECParameters params = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)curveOid);
        DEROctetString key = new DEROctetString(keyInfo.getPublicKeyData().getBytes());
        X9ECPoint derQ = new X9ECPoint(params.getCurve(), (ASN1OctetString)key);
        if (algorithm == 18) {
            PGPKdfParameters kdfParams = (PGPKdfParameters)algorithmParameters;
            if (kdfParams == null) {
                kdfParams = new PGPKdfParameters(8, 7);
            }
            ECDHPublicBCPGKey eCDHPublicBCPGKey = new ECDHPublicBCPGKey(curveOid, derQ.getPoint(), kdfParams.getHashAlgorithm(), kdfParams.getSymmetricWrapAlgorithm());
            return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
        } else {
            if (algorithm != 19) throw new PGPException("unknown EC algorithm");
            ECDSAPublicBCPGKey eCDSAPublicBCPGKey = new ECDSAPublicBCPGKey(curveOid, derQ.getPoint());
        }
        return new PGPPublicKey(new PublicKeyPacket(algorithm, time, (BCPGKey)var5_15), new BcKeyFingerprintCalculator());
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pubKey, AsymmetricKeyParameter privKey) throws PGPException {
        BCPGObject privPk;
        switch (pubKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKeyParameters rsK = (RSAPrivateCrtKeyParameters)privKey;
                privPk = new RSASecretBCPGKey(rsK.getExponent(), rsK.getP(), rsK.getQ());
                break;
            }
            case 17: {
                DSAPrivateKeyParameters dsK = (DSAPrivateKeyParameters)privKey;
                privPk = new DSASecretBCPGKey(dsK.getX());
                break;
            }
            case 16: 
            case 20: {
                ElGamalPrivateKeyParameters esK = (ElGamalPrivateKeyParameters)privKey;
                privPk = new ElGamalSecretBCPGKey(esK.getX());
                break;
            }
            case 18: 
            case 19: {
                ECPrivateKeyParameters ecK = (ECPrivateKeyParameters)privKey;
                privPk = new ECSecretBCPGKey(ecK.getD());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        return new PGPPrivateKey(pubKey.getKeyID(), pubKey.getPublicKeyPacket(), (BCPGKey)((Object)privPk));
    }

    public AsymmetricKeyParameter getPublicKey(PGPPublicKey publicKey) throws PGPException {
        PublicKeyPacket publicPk = publicKey.getPublicKeyPacket();
        try {
            switch (publicPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaK = (RSAPublicBCPGKey)publicPk.getKey();
                    return new RSAKeyParameters(false, rsaK.getModulus(), rsaK.getPublicExponent());
                }
                case 17: {
                    DSAPublicBCPGKey dsaK = (DSAPublicBCPGKey)publicPk.getKey();
                    return new DSAPublicKeyParameters(dsaK.getY(), new DSAParameters(dsaK.getP(), dsaK.getQ(), dsaK.getG()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elK = (ElGamalPublicBCPGKey)publicPk.getKey();
                    return new ElGamalPublicKeyParameters(elK.getY(), new ElGamalParameters(elK.getP(), elK.getG()));
                }
                case 18: 
                case 19: {
                    ECPublicBCPGKey ecPub = (ECPublicBCPGKey)publicPk.getKey();
                    X9ECParameters x9 = BcUtil.getX9Parameters(ecPub.getCurveOID());
                    return new ECPublicKeyParameters(BcUtil.decodePoint(ecPub.getEncodedPoint(), x9.getCurve()), (ECDomainParameters)new ECNamedDomainParameters(ecPub.getCurveOID(), x9.getCurve(), x9.getG(), x9.getN(), x9.getH()));
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception constructing public key", e);
        }
    }

    public AsymmetricKeyParameter getPrivateKey(PGPPrivateKey privKey) throws PGPException {
        PublicKeyPacket pubPk = privKey.getPublicKeyPacket();
        BCPGKey privPk = privKey.getPrivateKeyDataPacket();
        try {
            switch (pubPk.getAlgorithm()) {
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rsaPub = (RSAPublicBCPGKey)pubPk.getKey();
                    RSASecretBCPGKey rsaPriv = (RSASecretBCPGKey)privPk;
                    return new RSAPrivateCrtKeyParameters(rsaPriv.getModulus(), rsaPub.getPublicExponent(), rsaPriv.getPrivateExponent(), rsaPriv.getPrimeP(), rsaPriv.getPrimeQ(), rsaPriv.getPrimeExponentP(), rsaPriv.getPrimeExponentQ(), rsaPriv.getCrtCoefficient());
                }
                case 17: {
                    DSAPublicBCPGKey dsaPub = (DSAPublicBCPGKey)pubPk.getKey();
                    DSASecretBCPGKey dsaPriv = (DSASecretBCPGKey)privPk;
                    return new DSAPrivateKeyParameters(dsaPriv.getX(), new DSAParameters(dsaPub.getP(), dsaPub.getQ(), dsaPub.getG()));
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elPub = (ElGamalPublicBCPGKey)pubPk.getKey();
                    ElGamalSecretBCPGKey elPriv = (ElGamalSecretBCPGKey)privPk;
                    return new ElGamalPrivateKeyParameters(elPriv.getX(), new ElGamalParameters(elPub.getP(), elPub.getG()));
                }
                case 18: 
                case 19: {
                    ECPublicBCPGKey ecPub = (ECPublicBCPGKey)pubPk.getKey();
                    ECSecretBCPGKey ecPriv = (ECSecretBCPGKey)privPk;
                    X9ECParameters x9 = BcUtil.getX9Parameters(ecPub.getCurveOID());
                    return new ECPrivateKeyParameters(ecPriv.getX(), (ECDomainParameters)new ECNamedDomainParameters(ecPub.getCurveOID(), x9.getCurve(), x9.getG(), x9.getN(), x9.getH()));
                }
            }
            throw new PGPException("unknown public key algorithm encountered");
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception constructing key", e);
        }
    }
}

