/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp.operator.jcajce;

import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.spongycastle.jcajce.util.DefaultJcaJceHelper;
import org.spongycastle.jcajce.util.JcaJceHelper;
import org.spongycastle.jcajce.util.NamedJcaJceHelper;
import org.spongycastle.jcajce.util.ProviderJcaJceHelper;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.spongycastle.openpgp.operator.PGPDataDecryptor;
import org.spongycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.spongycastle.openpgp.operator.jcajce.OperatorHelper;
import org.spongycastle.openpgp.operator.jcajce.PGPUtil;

public class JcePBEDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private PGPDigestCalculatorProvider calculatorProvider;

    public JcePBEDataDecryptorFactoryBuilder(PGPDigestCalculatorProvider calculatorProvider) {
        this.calculatorProvider = calculatorProvider;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public PBEDataDecryptorFactory build(char[] passPhrase) {
        return new PBEDataDecryptorFactory(passPhrase, this.calculatorProvider){

            public byte[] recoverSessionData(int keyAlgorithm, byte[] key, byte[] secKeyData) throws PGPException {
                try {
                    if (secKeyData != null && secKeyData.length > 0) {
                        String cipherName = PGPUtil.getSymmetricCipherName(keyAlgorithm);
                        Cipher keyCipher = JcePBEDataDecryptorFactoryBuilder.this.helper.createCipher(cipherName + "/CFB/NoPadding");
                        keyCipher.init(2, (Key)new SecretKeySpec(key, cipherName), new IvParameterSpec(new byte[keyCipher.getBlockSize()]));
                        return keyCipher.doFinal(secKeyData);
                    }
                    byte[] keyBytes = new byte[key.length + 1];
                    keyBytes[0] = (byte)keyAlgorithm;
                    System.arraycopy(key, 0, keyBytes, 1, key.length);
                    return keyBytes;
                }
                catch (Exception e) {
                    throw new PGPException("Exception recovering session info", e);
                }
            }

            public PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, int encAlgorithm, byte[] key) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.helper.createDataDecryptor(withIntegrityPacket, encAlgorithm, key);
            }
        };
    }
}

