/*
 * Decompiled with CFR 0.152.
 */
package com.menecats.polybool;

import com.menecats.polybool.helpers.PolyBoolHelper;
import java.util.List;

public class Epsilon {
    protected double eps;

    public Epsilon() {
        this(1.0E-10);
    }

    public Epsilon(double eps) {
        this.eps = eps;
    }

    public double epsilon(double eps) {
        this.eps = Math.abs(eps);
        return this.eps;
    }

    public boolean pointAboveOrOnLine(double[] pt, double[] left, double[] right) {
        double Bx = right[0];
        double Ax = left[0];
        double Cy = pt[1];
        double Ay = left[1];
        double By = right[1];
        double Cx = pt[0];
        return (Bx - Ax) * (Cy - Ay) - (By - Ay) * (Cx - Ax) >= -this.eps;
    }

    public boolean pointBetween(double[] p, double[] left, double[] right) {
        double d_px_lx = p[0] - left[0];
        double d_rx_lx = right[0] - left[0];
        double d_py_ly = p[1] - left[1];
        double d_ry_ly = right[1] - left[1];
        double dot = d_px_lx * d_rx_lx + d_py_ly * d_ry_ly;
        if (dot < this.eps) {
            return false;
        }
        double sqlen = d_rx_lx * d_rx_lx + d_ry_ly * d_ry_ly;
        return !(dot - sqlen > -this.eps);
    }

    public boolean pointsSameX(double[] p1, double[] p2) {
        return Math.abs(p1[0] - p2[0]) < this.eps;
    }

    public boolean pointsSameY(double[] p1, double[] p2) {
        return Math.abs(p1[1] - p2[1]) < this.eps;
    }

    public boolean pointsSame(double[] p1, double[] p2) {
        return this.pointsSameX(p1, p2) && this.pointsSameY(p1, p2);
    }

    public int pointsCompare(double[] p1, double[] p2) {
        if (this.pointsSameX(p1, p2)) {
            return this.pointsSameY(p1, p2) ? 0 : (p1[1] < p2[1] ? -1 : 1);
        }
        return p1[0] < p2[0] ? -1 : 1;
    }

    public boolean pointsCollinear(double[] pt1, double[] pt2, double[] pt3) {
        double dx1 = pt1[0] - pt2[0];
        double dy2 = pt2[1] - pt3[1];
        double dx2 = pt2[0] - pt3[0];
        double dy1 = pt1[1] - pt2[1];
        return Math.abs(dx1 * dy2 - dx2 * dy1) < this.eps;
    }

    public EpsilonIntersectionResult linesIntersect(double[] a0, double[] a1, double[] b0, double[] b1) {
        double adx = a1[0] - a0[0];
        double bdy = b1[1] - b0[1];
        double ady = a1[1] - a0[1];
        double bdx = b1[0] - b0[0];
        double axb = adx * bdy - ady * bdx;
        if (Math.abs(axb) < this.eps) {
            return null;
        }
        double dx = a0[0] - b0[0];
        double dy = a0[1] - b0[1];
        double A = (bdx * dy - bdy * dx) / axb;
        double B = (adx * dy - ady * dx) / axb;
        EpsilonIntersectionResult ret = new EpsilonIntersectionResult();
        ret.pt = PolyBoolHelper.point(a0[0] + A * adx, a0[1] + A * ady);
        ret.alongA = A <= -this.eps ? -2 : (A < this.eps ? -1 : (A - 1.0 <= -this.eps ? 0 : (A - 1.0 < this.eps ? 1 : 2)));
        ret.alongB = B <= -this.eps ? -2 : (B < this.eps ? -1 : (B - 1.0 <= -this.eps ? 0 : (B - 1.0 < this.eps ? 1 : 2)));
        return ret;
    }

    public boolean pointInsideRegion(double[] pt, List<double[]> region) {
        double x = pt[0];
        double y = pt[1];
        double last_x = region.get(region.size() - 1)[0];
        double last_y = region.get(region.size() - 1)[1];
        boolean inside = false;
        for (double[] regionPt : region) {
            double curr_x = regionPt[0];
            double curr_y = regionPt[1];
            if (curr_y - y > this.eps != last_y - y > this.eps && (last_x - curr_x) * (y - curr_y) / (last_y - curr_y) + curr_x - x > this.eps) {
                inside = !inside;
            }
            last_x = curr_x;
            last_y = curr_y;
        }
        return inside;
    }

    public static class EpsilonIntersectionResult {
        public int alongA;
        public int alongB;
        public double[] pt;
    }
}

