/*
 * Decompiled with CFR 0.152.
 */
package com.menecats.polybool.internal;

import com.menecats.polybool.Epsilon;
import com.menecats.polybool.internal.LinkedList;
import com.menecats.polybool.models.Segment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AbstractIntersecter {
    protected final Epsilon eps;
    private final boolean selfIntersection;
    private final LinkedList<IntersecterContent> event_root = LinkedList.create();

    AbstractIntersecter(boolean selfIntersection, Epsilon eps) {
        this.eps = eps;
        this.selfIntersection = selfIntersection;
    }

    protected Segment segmentNew(double[] start, double[] end) {
        return new Segment(start, end);
    }

    protected Segment segmentCopy(double[] start, double[] end, Segment seg) {
        return new Segment(start, end, new Segment.SegmentFill(seg.myFill.above, seg.myFill.below));
    }

    private int eventCompare(boolean p1_isStart, double[] p1_1, double[] p1_2, boolean p2_isStart, double[] p2_1, double[] p2_2) {
        int comp = this.eps.pointsCompare(p1_1, p2_1);
        if (comp != 0) {
            return comp;
        }
        if (this.eps.pointsSame(p1_2, p2_2)) {
            return 0;
        }
        if (p1_isStart != p2_isStart) {
            return p1_isStart ? 1 : -1;
        }
        return this.eps.pointAboveOrOnLine(p1_2, p2_isStart ? p2_1 : p2_2, p2_isStart ? p2_2 : p2_1) ? 1 : -1;
    }

    private void eventAdd(LinkedList<IntersecterContent> ev, double[] other_pt) {
        this.event_root.insertBefore(ev, here -> {
            int comp = this.eventCompare(((IntersecterContent)ev.getContent()).isStart, ((IntersecterContent)ev.getContent()).pt, other_pt, ((IntersecterContent)here.getContent()).isStart, ((IntersecterContent)here.getContent()).pt, ((IntersecterContent)here.getContent()).other.getContent().pt);
            return comp < 0;
        });
    }

    private LinkedList<IntersecterContent> eventAddSegmentStart(Segment seg, boolean primary) {
        IntersecterContent content = new IntersecterContent();
        content.isStart = true;
        content.pt = seg.start;
        content.seg = seg;
        content.primary = primary;
        LinkedList<IntersecterContent> ev_start = LinkedList.node(content);
        this.eventAdd(ev_start, seg.end);
        return ev_start;
    }

    private void eventAddSegmentEnd(LinkedList<IntersecterContent> ev_start, Segment seg, boolean primary) {
        IntersecterContent content = new IntersecterContent();
        content.isStart = false;
        content.pt = seg.end;
        content.seg = seg;
        content.primary = primary;
        content.other = ev_start;
        LinkedList<IntersecterContent> ev_end = LinkedList.node(content);
        ev_start.getContent().other = ev_end;
        this.eventAdd(ev_end, ev_start.getContent().pt);
    }

    protected LinkedList<IntersecterContent> eventAddSegment(Segment seg, boolean primary) {
        LinkedList<IntersecterContent> ev_start = this.eventAddSegmentStart(seg, primary);
        this.eventAddSegmentEnd(ev_start, seg, primary);
        return ev_start;
    }

    private void eventUpdateEnd(LinkedList<IntersecterContent> ev, double[] end) {
        ev.getContent().other.remove();
        ev.getContent().seg.end = end;
        ev.getContent().other.getContent().pt = end;
        this.eventAdd(ev.getContent().other, ev.getContent().pt);
    }

    private LinkedList<IntersecterContent> eventDivide(LinkedList<IntersecterContent> ev, double[] pt) {
        Segment ns = this.segmentCopy(pt, ev.getContent().seg.end, ev.getContent().seg);
        this.eventUpdateEnd(ev, pt);
        return this.eventAddSegment(ns, ev.getContent().primary);
    }

    protected List<Segment> baseCalculate(boolean primaryPolyInverted, boolean secondaryPolyInverted) {
        LinkedList<LinkedList<IntersecterContent>> status_root = LinkedList.create();
        BiFunction<LinkedList, LinkedList, Integer> statusCompare = (ev1, ev2) -> {
            double[] a1 = ((IntersecterContent)ev1.getContent()).seg.start;
            double[] a2 = ((IntersecterContent)ev1.getContent()).seg.end;
            double[] b1 = ((IntersecterContent)ev2.getContent()).seg.start;
            double[] b2 = ((IntersecterContent)ev2.getContent()).seg.end;
            if (this.eps.pointsCollinear(a1, b1, b2)) {
                if (this.eps.pointsCollinear(a2, b1, b2)) {
                    return 1;
                }
                return this.eps.pointAboveOrOnLine(a2, b1, b2) ? 1 : -1;
            }
            return this.eps.pointAboveOrOnLine(a1, b1, b2) ? 1 : -1;
        };
        Function<LinkedList, LinkedList.TransitionResult> statusFindSurrounding = ev -> status_root.findTransition(here -> {
            int comp = (Integer)statusCompare.apply((LinkedList)ev, (LinkedList)here.getContent());
            return comp > 0;
        });
        BiFunction<LinkedList, LinkedList, LinkedList> checkIntersection = (ev1, ev2) -> {
            Segment seg1 = ((IntersecterContent)ev1.getContent()).seg;
            Segment seg2 = ((IntersecterContent)ev2.getContent()).seg;
            double[] a1 = seg1.start;
            double[] a2 = seg1.end;
            double[] b1 = seg2.start;
            double[] b2 = seg2.end;
            Epsilon.EpsilonIntersectionResult i = this.eps.linesIntersect(a1, a2, b1, b2);
            if (i == null) {
                boolean a2_between;
                if (!this.eps.pointsCollinear(a1, a2, b1)) {
                    return null;
                }
                if (this.eps.pointsSame(a1, b2) || this.eps.pointsSame(a2, b1)) {
                    return null;
                }
                boolean a1_equ_b1 = this.eps.pointsSame(a1, b1);
                boolean a2_equ_b2 = this.eps.pointsSame(a2, b2);
                if (a1_equ_b1 && a2_equ_b2) {
                    return ev2;
                }
                boolean a1_between = !a1_equ_b1 && this.eps.pointBetween(a1, b1, b2);
                boolean bl = a2_between = !a2_equ_b2 && this.eps.pointBetween(a2, b1, b2);
                if (a1_equ_b1) {
                    if (a2_between) {
                        this.eventDivide((LinkedList<IntersecterContent>)ev2, a2);
                    } else {
                        this.eventDivide((LinkedList<IntersecterContent>)ev1, b2);
                    }
                    return ev2;
                }
                if (a1_between) {
                    if (!a2_equ_b2) {
                        if (a2_between) {
                            this.eventDivide((LinkedList<IntersecterContent>)ev2, a2);
                        } else {
                            this.eventDivide((LinkedList<IntersecterContent>)ev1, b2);
                        }
                    }
                    this.eventDivide((LinkedList<IntersecterContent>)ev2, a1);
                }
            } else {
                if (i.alongA == 0) {
                    if (i.alongB == -1) {
                        this.eventDivide((LinkedList<IntersecterContent>)ev1, b1);
                    } else if (i.alongB == 0) {
                        this.eventDivide((LinkedList<IntersecterContent>)ev1, i.pt);
                    } else if (i.alongB == 1) {
                        this.eventDivide((LinkedList<IntersecterContent>)ev1, b2);
                    }
                }
                if (i.alongB == 0) {
                    if (i.alongA == -1) {
                        this.eventDivide((LinkedList<IntersecterContent>)ev2, a1);
                    } else if (i.alongA == 0) {
                        this.eventDivide((LinkedList<IntersecterContent>)ev2, i.pt);
                    } else if (i.alongA == 1) {
                        this.eventDivide((LinkedList<IntersecterContent>)ev2, a2);
                    }
                }
            }
            return null;
        };
        ArrayList<Segment> segments = new ArrayList<Segment>();
        while (!this.event_root.isEmpty()) {
            LinkedList<IntersecterContent> ev3 = this.event_root.getHead();
            if (ev3.getContent().isStart) {
                boolean toggle;
                LinkedList below;
                LinkedList.TransitionResult surrounding = statusFindSurrounding.apply(ev3);
                LinkedList above = surrounding.before != null ? (LinkedList)surrounding.before.getContent() : null;
                Supplier<LinkedList> checkBothIntersections = () -> AbstractIntersecter.lambda$baseCalculate$5(above, checkIntersection, ev3, below = surrounding.after != null ? (LinkedList)surrounding.after.getContent() : null);
                LinkedList eve = checkBothIntersections.get();
                if (eve != null) {
                    if (this.selfIntersection) {
                        if (ev3.getContent().seg.myFill.below == null) {
                            toggle = true;
                        } else {
                            boolean bl = toggle = ev3.getContent().seg.myFill.above != ev3.getContent().seg.myFill.below;
                        }
                        if (toggle) {
                            ((IntersecterContent)eve.getContent()).seg.myFill.above = ((IntersecterContent)eve.getContent()).seg.myFill.above == false;
                        }
                    } else {
                        ((IntersecterContent)eve.getContent()).seg.otherFill = ev3.getContent().seg.myFill;
                    }
                    ev3.getContent().other.remove();
                    ev3.remove();
                }
                if (this.event_root.getHead() != ev3) continue;
                if (this.selfIntersection) {
                    toggle = ev3.getContent().seg.myFill.below == null ? true : ev3.getContent().seg.myFill.above != ev3.getContent().seg.myFill.below;
                    ev3.getContent().seg.myFill.below = below == null ? Boolean.valueOf(primaryPolyInverted) : ((IntersecterContent)below.getContent()).seg.myFill.above;
                    ev3.getContent().seg.myFill.above = toggle ? Boolean.valueOf(ev3.getContent().seg.myFill.below == false) : ev3.getContent().seg.myFill.below;
                } else if (ev3.getContent().seg.otherFill == null) {
                    boolean inside = below == null ? (ev3.getContent().primary ? secondaryPolyInverted : primaryPolyInverted) : (ev3.getContent().primary == ((IntersecterContent)below.getContent()).primary ? ((IntersecterContent)below.getContent()).seg.otherFill.above.booleanValue() : ((IntersecterContent)below.getContent()).seg.myFill.above.booleanValue());
                    ev3.getContent().seg.otherFill = new Segment.SegmentFill(inside, inside);
                }
                ev3.getContent().other.getContent().status = surrounding.insert.apply(LinkedList.node(ev3));
            } else {
                LinkedList<LinkedList<IntersecterContent>> st = ev3.getContent().status;
                if (st == null) {
                    throw new RuntimeException("PolyBool: Zero-length segment detected; your epsilon is probably too small or too large");
                }
                if (status_root.exists(st.getPrev()) && status_root.exists(st.getNext())) {
                    checkIntersection.apply(st.getPrev().getContent(), st.getNext().getContent());
                }
                st.remove();
                if (!ev3.getContent().primary) {
                    Segment.SegmentFill s = ev3.getContent().seg.myFill;
                    ev3.getContent().seg.myFill = ev3.getContent().seg.otherFill;
                    ev3.getContent().seg.otherFill = s;
                }
                segments.add(ev3.getContent().seg);
            }
            this.event_root.getHead().remove();
        }
        return segments;
    }

    private static /* synthetic */ LinkedList lambda$baseCalculate$5(LinkedList above, BiFunction checkIntersection, LinkedList ev, LinkedList below) {
        LinkedList eve;
        if (above != null && (eve = (LinkedList)checkIntersection.apply(ev, above)) != null) {
            return eve;
        }
        if (below != null) {
            return (LinkedList)checkIntersection.apply(ev, below);
        }
        return null;
    }

    protected static class IntersecterContent {
        boolean isStart;
        double[] pt;
        Segment seg;
        boolean primary;
        LinkedList<IntersecterContent> other;
        LinkedList<LinkedList<IntersecterContent>> status;

        protected IntersecterContent() {
        }
    }
}

