/*
 * Decompiled with CFR 0.152.
 */
package com.menecats.polybool.internal;

import com.menecats.polybool.Epsilon;
import com.menecats.polybool.models.Segment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class SegmentChainer {
    public static List<List<double[]>> chain(List<Segment> segments, Epsilon eps) {
        ArrayList chains = new ArrayList();
        ArrayList<List<double[]>> regions = new ArrayList<List<double[]>>();
        for (Segment seg : segments) {
            boolean reverseF;
            double[] pt1 = seg.start;
            double[] pt2 = seg.end;
            if (eps.pointsSame(pt1, pt2)) {
                System.err.println("PolyBool: Warning: Zero-length segment detected; your epsilon is probably too small or too large");
                return null;
            }
            SegmentChainerMatch first_match = new SegmentChainerMatch();
            SegmentChainerMatch second_match = new SegmentChainerMatch();
            SegmentChainerMatch[] next_match = new SegmentChainerMatch[]{first_match};
            TriPredicate<Integer, Boolean, Boolean> setMatch = (index, matches_head, matches_pt1) -> {
                next_match[0].index = index;
                next_match[0].matches_head = matches_head;
                next_match[0].matches_pt1 = matches_pt1;
                if (next_match[0] == first_match) {
                    next_match[0] = second_match;
                    return false;
                }
                next_match[0] = null;
                return true;
            };
            for (int i = 0; i < chains.size(); ++i) {
                List chain = (List)chains.get(i);
                double[] head = (double[])chain.get(0);
                double[] tail = (double[])chain.get(chain.size() - 1);
                if (eps.pointsSame(head, pt1) ? setMatch.apply(i, true, true) : (eps.pointsSame(head, pt2) ? setMatch.apply(i, true, false) : (eps.pointsSame(tail, pt1) ? setMatch.apply(i, false, true) : eps.pointsSame(tail, pt2) && setMatch.apply(i, false, false)))) break;
            }
            if (next_match[0] == first_match) {
                ArrayList<double[]> newChain = new ArrayList<double[]>();
                newChain.add(pt1);
                newChain.add(pt2);
                chains.add(newChain);
                continue;
            }
            if (next_match[0] == second_match) {
                double[] oppo2;
                int index3 = first_match.index;
                double[] pt = first_match.matches_pt1 ? pt2 : pt1;
                boolean addToHead = first_match.matches_head;
                List chain = (List)chains.get(index3);
                double[] grow = addToHead ? (double[])chain.get(0) : (double[])chain.get(chain.size() - 1);
                double[] grow2 = addToHead ? (double[])chain.get(1) : (double[])chain.get(chain.size() - 2);
                double[] oppo = addToHead ? (double[])chain.get(chain.size() - 1) : (double[])chain.get(0);
                double[] dArray = oppo2 = addToHead ? (double[])chain.get(chain.size() - 2) : (double[])chain.get(1);
                if (eps.pointsCollinear(grow2, grow, pt)) {
                    if (addToHead) {
                        chain.remove(0);
                    } else {
                        chain.remove(chain.size() - 1);
                    }
                    grow = grow2;
                }
                if (eps.pointsSame(oppo, pt)) {
                    chains.remove(index3);
                    if (eps.pointsCollinear(oppo2, oppo, grow)) {
                        if (addToHead) {
                            chain.remove(chain.size() - 1);
                        } else {
                            chain.remove(0);
                        }
                    }
                    regions.add(chain);
                    continue;
                }
                if (addToHead) {
                    chain.add(0, pt);
                    continue;
                }
                chain.add(pt);
                continue;
            }
            Consumer<Integer> reverseChain = index -> Collections.reverse((List)chains.get((int)index));
            BiConsumer<Integer, Integer> appendChain = (index1, index2) -> {
                List chain1 = (List)chains.get((int)index1);
                List chain2 = (List)chains.get((int)index2);
                double[] tail = (double[])chain1.get(chain1.size() - 1);
                double[] tail2 = (double[])chain1.get(chain1.size() - 2);
                double[] head = (double[])chain2.get(0);
                double[] head2 = (double[])chain2.get(1);
                if (eps.pointsCollinear(tail2, tail, head)) {
                    chain1.remove(chain1.size() - 1);
                    tail = tail2;
                }
                if (eps.pointsCollinear(tail, head, head2)) {
                    chain2.remove(0);
                }
                ArrayList concatenated = new ArrayList();
                concatenated.addAll(chain1);
                concatenated.addAll(chain2);
                chains.set((int)index1, concatenated);
                chains.remove((int)index2);
            };
            int F = first_match.index;
            int S = second_match.index;
            boolean bl = reverseF = ((List)chains.get(F)).size() < ((List)chains.get(S)).size();
            if (first_match.matches_head) {
                if (second_match.matches_head) {
                    if (reverseF) {
                        reverseChain.accept(F);
                        appendChain.accept(F, S);
                        continue;
                    }
                    reverseChain.accept(S);
                    appendChain.accept(S, F);
                    continue;
                }
                appendChain.accept(S, F);
                continue;
            }
            if (second_match.matches_head) {
                appendChain.accept(F, S);
                continue;
            }
            if (reverseF) {
                reverseChain.accept(F);
                appendChain.accept(S, F);
                continue;
            }
            reverseChain.accept(S);
            appendChain.accept(F, S);
        }
        return regions;
    }

    private static interface TriPredicate<T, U, V> {
        public boolean apply(T var1, U var2, V var3);
    }

    private static class SegmentChainerMatch {
        int index;
        boolean matches_head;
        boolean matches_pt1;

        public SegmentChainerMatch() {
            this(0, false, false);
        }

        public SegmentChainerMatch(int index, boolean matches_head, boolean matches_pt1) {
            this.index = index;
            this.matches_head = matches_head;
            this.matches_pt1 = matches_pt1;
        }
    }
}

